package cn.com.duiba.quanyi.center.api.enums.demand;

import cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2025/7/7 16:03
 **/
@Getter
@AllArgsConstructor
public enum DemandChangeTypeEnum {
    CREATE_DEMAND(1, "创建需求", WorkflowTypeEnum.CREATE_DEMAND.getType()),
    ADD_DEMAND_GOODS(2, "添加需求商品", WorkflowTypeEnum.ADD_DEMAND_GOODS.getType()),
    UPDATE_CONSUME_BUDGET(3, "更新需求预算", WorkflowTypeEnum.MODIFY_DEMAND_BUDGET.getType());

    private final Integer type;

    private final String desc;

    private final Integer workflowType;

    public static DemandChangeTypeEnum getByType(Integer changeType) {
        for (DemandChangeTypeEnum value : values()) {
            if (value.type.equals(changeType)) {
                return value;
            }
        }
        return null;
    }

    public static final Integer getWorkflowTypeByChangeType(Integer changeType) {
        DemandChangeTypeEnum demandChangeTypeEnum = getByType(changeType);
        if (demandChangeTypeEnum != null) {
            return demandChangeTypeEnum.workflowType;
        }
        return null;
    }
}
