package cn.com.duiba.quanyi.center.api.dto.insurance.auto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 保司资金账户导入拆分变更记录表
 * @author mybatis generator
 * @date 2025-07-17
 */
@Data
public class InsuranceFundAccountImportSplitChangeRecordDto implements Serializable {

    private static final long serialVersionUID = 17527243920792722L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 手机号
     */
    private String accountPhone;

    /**
     * 业务类型，1-权益发放，2-权益金额增加，3-权益金额追加，4-权益金额减少，5-变更发放账号，6-兑换
     */
    private Integer bizType;

    /**
     * 关联业务唯一标识
     */
    private String bizNo;

    /**
     * 导入变更金额，单位分
     */
    private Long currentImportedDelta;

    /**
     * 已兑换变更金额，单位分
     */
    private Long currentRedeemedDelta;

    /**
     * 退回变更金额，单位分
     */
    private Long currentRefundedDelta;

    /**
     * 变更后导入金额，单位分
     */
    private Long importedAmountAfter;

    /**
     * 变更后已领取金额，单位分
     */
    private Long redeemedAmountAfter;

    /**
     * 变更后已退回金额，单位分
     */
    private Long refundedAmountAfter;

    /**
     * 变更备注
     */
    private String changeRemark;

    /**
     * 本次未兑换变更详情
     */
    private String currentUnredeemedDetailChanges;
}
