package cn.com.duiba.quanyi.center.api.dto.wx;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author yinjiaqi
 * @date 2025-05-19 11:04:25
 */
@Data
public class WxCouponEsDto implements Serializable {
    private static final long serialVersionUID = 787325832460937118L;

    /**
     * 微信立减金ID
     * tb_wx_coupon.id
     */
    private Long id;
    /**
     * 批次号
     */
    private String stockId;
    /**
     * 创建人
     */
    private Long createOperatorId;
    /**
     * 批次号名称
     */
    private String stockName;
    /**
     * 制券商户
     */
    private String stockCreatorMchId;
    /**
     * 发券商户
     */
    private String mchId;
    /**
     * 批次类型
     */
    private Integer stockType;
    /**
     * 状态
     */
    private String stockStatus;
    /**
     * 项目id
     */
    private Long projectId;
    /**
     * 需求id
     */
    private Long demandId;
    /**
     * 需求商品id
     */
    private Long demandGoodsId;
    /**
     * 批次创建时间
     */
    private Date createTime;

    /**
     * 全部可发放商户号
     */
    private List<String> sendMchIds;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;
    /**
     * 业务状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockBizStatusEnum
     */
    private Integer bizStatus;

}
