package cn.com.duiba.quanyi.center.api.param.refund;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 退款变更记录分页查询参数
 *
 * @author yangyukang
 * @date 2025/1/21
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RefundChangeRecordPageQueryParam extends PageQuery {

    /**
     * 退款总金额，单位为分
     */
    private Long totalRefundAmount;

    /**
     * 退款原因
     */
    private String refundReason;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 上传任务ID
     */
    private Long uploadTaskId;

    /**
     * 审批状态
     */
    private Integer approvalStatus;

    /**
     * 操作人sso用户ID
     */
    private Long operatorSsoId;

    /**
     * 操作人sso姓名
     */
    private String operatorSsoName;

    /**
     * 钉钉用户ID
     */
    private String dingTalkUserId;

    /**
     * 钉钉部门ID
     */
    private Long dingTalkDeptId;

    /**
     * 创建时间开始
     */
    private Date gmtCreateStart;

    /**
     * 创建时间结束
     */
    private Date gmtCreateEnd;

    /**
     * 修改时间开始
     */
    private Date gmtModifiedStart;

    /**
     * 修改时间结束
     */
    private Date gmtModifiedEnd;
}
