package cn.com.duiba.quanyi.center.api.remoteservice.qy.signing;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.signing.UserSigningDto;
import cn.com.duiba.quanyi.center.api.param.qy.signing.UserSigningSearchParam;
import java.util.List;

/**
 * 用户签约表
 * @author kjj mybatis generator 
 * @date 2024-05-09
 */
@AdvancedFeignClient
public interface RemoteUserSigningService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 用户签约集合
     */
    List<UserSigningDto> selectPage(UserSigningSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(UserSigningSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户签约
     */
    UserSigningDto selectById(Long id);

    /**
     *  根据用户id查询
     * @param userId
     * @return
     */
    List<UserSigningDto> selectByUserId(Long userId);

    /**
     * 新增
     * @param dto 用户签约
     * @return 执行结果
     */
    Long insert(UserSigningDto dto) throws BizException;

    /**
     * 更新
     * @param dto 用户签约
     * @return 影响行数
     */
    int update(UserSigningDto dto);
}