package cn.com.duiba.quanyi.center.api.utils.insurance;

import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 保司-提现计算工具
 * @author yinjiaqi
 * @date 2025-03-24 11:36:41
 */
public class InsuranceTakeAmountUtil {
    /**
     * 计算手续费
     * @param rateWithdrawal 费率
     * @param amount 金额
     * @return 手续费
     */
    public static long calculateCommission(String rateWithdrawal, Long amount) {
        if (amount == null || amount == 0 || StringUtils.isBlank(rateWithdrawal)) {
            return 0;
        }
        BigDecimal rate = new BigDecimal(rateWithdrawal);
        // 元维度向上取整（费率*金额）
        long commission = rate.multiply(new BigDecimal(amount)).divide(BigDecimal.valueOf(100), 0, RoundingMode.HALF_UP).longValue();
        // 转成分
        return commission * 100;
    }
}
