package cn.com.duiba.quanyi.center.api.remoteservice.qy.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.AlipayActivityDto;
import cn.com.duiba.quanyi.center.api.dto.qy.coupon.AlipayActivityAutoAddMoneyTaskDto;
import cn.com.duiba.quanyi.center.api.param.coupon.notify.AlipayActivityAddMoneyResultNotifyParam;
import cn.com.duiba.quanyi.center.api.param.qy.coupon.AlipayActivityAutoAddMoneyTaskSearchParam;
import java.util.List;
import java.util.Map;

/**
 * 支付宝立减金自动加款任务表
 * @author kjj mybatis generator
 * @date 2024-09-02
 */
@AdvancedFeignClient
public interface RemoteAlipayActivityAutoAddMoneyTaskService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 支付宝立减金自动加款任务集合
     */
    List<AlipayActivityAutoAddMoneyTaskDto> selectPage(AlipayActivityAutoAddMoneyTaskSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AlipayActivityAutoAddMoneyTaskSearchParam param);


    /**
     * 查询需要加款的任务列表 根据添加时间排序
     *
     * @param size 需要的任务数
     * @return 加款任务列表
     */
    List<AlipayActivityAutoAddMoneyTaskDto> selectNeedAddMoneyTasks(Integer size);

    /**
     * 根据ids查询任务明细
     *
     * @param ids ids
     * @return 任务明细
     */
    List<AlipayActivityAutoAddMoneyTaskDto> selectByIds(List<Long> ids);

    /**
     * 创建指定金额的加款任务（仅b端手动加款用）
     * @param actId 活动id
     * @param amount 加款后金额
     * @return 失败原因
     */
    String createAddMoneyTask(String actId, Long amount);

    /**
     * 加款结果通知
     *
     * @param notifyParams 加款结果通知参数
     */
    void addMoneyResultNotify(List<AlipayActivityAddMoneyResultNotifyParam> notifyParams) ;
}
