package cn.com.duiba.quanyi.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.UserExtAlipayDto;

import java.util.List;

/**
 * 用户扩展信息-支付宝
 * @author kjj mybatis generator
 * @date 2025-09-30
 */
@AdvancedFeignClient
public interface RemoteUserExtAlipayService {

    /**
     * 新增或保存
     * @param dto 关联信息
     * @return 执行结果
     */
    int saveOrUpdate(UserExtAlipayDto dto);

    /**
     * 根据唯一约束查询，redis缓存，变更时清除缓存
     *
     * @param alipayUserId 支付宝用户ID
     * @param userType 用户类型
     * @see cn.com.duiba.quanyi.center.api.enums.user.UserTypeEnum
     * @param openId 支付宝openId
     * @param appId 支付宝appId
     * @return 用户关联信息
     */
    UserExtAlipayDto selectByUnionKeyCache(String alipayUserId, Integer userType, String openId, String appId);

    /**
     * 根据userId
     * @param userId 用户Id
     * @return 用户关联信息
     */
    List<UserExtAlipayDto> selectByUserId(Long userId);
}
