package cn.com.duiba.quanyi.center.api.dto.demand;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2025/7/17 14:35
 **/
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DemandGoodsUpdateConsumeBudgetResultDto implements Serializable {
    /**
     * 是否更新成功
     */
    private boolean success;

    /**
     * 失败原因（成功时为null）
     */
    private String failReason;

    /**
     * 创建成功结果
     */
    public static DemandGoodsUpdateConsumeBudgetResultDto success() {
        return new DemandGoodsUpdateConsumeBudgetResultDto(true, null);
    }

    /**
     * 创建失败结果
     */
    public static DemandGoodsUpdateConsumeBudgetResultDto failure(String failReason) {
        return new DemandGoodsUpdateConsumeBudgetResultDto(false, failReason);
    }
}
