package cn.com.duiba.quanyi.center.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/27 13:45
 */
@Slf4j
@Getter
@AllArgsConstructor
public enum ExpressCompanyCodeEnum {
    OTHER("其他公司", "other_company"),
    YUANTONG("圆通速递", "yuantong"),
    SHENTONG("申通快递", "shentong"),
    ZHONGTONG("中通快递", "zhongtong"),
    JTEXPRESS("极兔速递", "jtexpress"),
    YUNDA("韵达快递", "yunda"),
    YOUZHENGGUONEI("邮政快递包裹", "youzhengguonei"),
    SHUNFENG("顺丰速运", "shunfeng"),
    EMS("EMS", "ems"),
    JD("京东物流", "jd"),
    YOUZHENGDSBK("邮政电商标快", "youzhengdsbk"),
    YOUZHENGBK("邮政标准快递", "youzhengbk"),
    DEBANGKUAIDI("德邦快递", "debangkuaidi"),
    DANNIAO("丹鸟", "danniao"),
    SHUNFENGKUAIYUN("顺丰快运", "shunfengkuaiyun"),
    DEBANGWULIU("德邦", "debangwuliu"),
    ZHONGTONGKUAIYUN("中通快运", "zhongtongkuaiyun"),
    ANNENGWULIU("安能快运", "annengwuliu"),
    SUER("速尔快递", "suer"),
    JINGDONGKUAIYUN("京东快运", "jingdongkuaiyun"),
    KUAYUE("跨越速运", "kuayue"),
    SUBIDA("速必达", "subida"),
    LIANHAOWULIU("联昊通", "lianhaowuliu"),
    BAISHIWULIU("百世快运", "baishiwuliu"),
    YOUZHENGGUOJI("国际包裹", "youzhengguoji"),
    SXJDFREIGHT("顺心捷达", "sxjdfreight"),
    RRS("日日顺物流", "rrs"),
    YUNDAKUAIYUN("韵达快运", "yundakuaiyun"),
    ZHAIJISONG("宅急送", "zhaijisong"),
    HUITONGKUAIDI("百世快递", "huitongkuaidi"),
    YIMIDIDA("壹米滴答", "yimidida"),
    ZTKY("中铁快运", "ztky"),
    ANNTO("安得物流", "annto"),
    JINGUANGSUDIKUAIJIAN("京广速递", "jinguangsudikuaijian"),
    ZHONGTONGGUOJI("中通国际", "zhongtongguoji"),
    YOUSHUWULIU("优速", "youshuwuliu"),
    UPSEN("UPS-全球件", "upsen"),
    XINFENGWULIU("信丰物流", "xinfengwuliu"),
    JIAYUNMEIWULIU("加运美", "jiayunmeiwuliu"),
    PINGANDATENGFEI("平安达腾飞", "pingandatengfei"),
    DISIFANG("递四方", "disifang"),
    ECMSCN("易客满", "ecmscn"),
    CAINIAOZHISONG("菜鸟直送(丹鸟)", "cainiaozhisong"),
    DHL("DHL-中国件", "dhl"),
    SAVOR("海信物流", "savor"),
    SUNING("苏宁物流", "suning"),
    UPS("UPS", "ups"),
    HUISENKY("汇森速运", "huisenky"),
    DHLEN("DHL-全球件", "dhlen"),
    SUTENG("速腾快递", "suteng"),
    FEDEXCN("Fedex-国际件-中文", "fedexcn"),
    FEDEX("FedEx-国际件", "fedex"),
    EMSWULIU("EMS物流", "emswuliu"),
    ZHONGYOUEX("众邮快递", "zhongyouex"),
    ZHIMAKAIMEN("芝麻开门", "zhimakaimen"),
    SHPOST("同城快寄", "shpost"),
    SHUNFENGLENGYUN("顺丰冷链", "shunfenglengyun"),
    EWE("EWE全球快递", "ewe"),
    YUXINWULIU("宇鑫物流", "yuxinwuliu"),
    COSCO("中远e环球", "cosco"),
    YUANTONGGUOJI("圆通国际", "yuantongguoji"),
    TIMELYTITAN("Titan泰坦国际速递", "timelytitan"),
    BAITENGWULIU("百腾物流", "baitengwuliu"),
    USPS("USPS", "usps"),
    SHUNCHANGGUOJI("顺昌国际", "shunchangguoji"),
    SFWL("盛丰物流", "sfwl"),
    ANE66("安能快递", "ane66"),
    LNTJS("特急送", "lntjs"),
    NSF("新顺丰（NSF）", "nsf"),
    YUNTRACK("YunExpress", "yuntrack"),
    HD("宏递快运", "hd"),
    QHXYYG("雪域易购", "qhxyyg"),
    SUYODA("速邮达", "suyoda"),
    EXFRESH("安鲜达", "exfresh"),
    GOODAY365("日日顺智慧物联", "gooday365"),
    SAGAWA("佐川急便", "sagawa"),
    XJDAISHU("袋鼠速递", "xjdaishu"),
    CHINAPOST("中国邮政（CHINA POST）", "chinapost"),
    WHEREXPESS("威盛快递", "wherexpess"),
    SUT56("速通物流", "sut56"),
    YUNDAASIA("yundaasia", "yundaasia"),
    ZHAIJIBIAN("宅急便", "zhaijibian"),
    AUEXPRESS("澳邮中国快运", "auexpress"),
    MANWAH("敏華物流", "manwah"),
    LAHUOEX("拉火速运", "lahuoex"),
    DPD("DPD", "dpd"),
    TNJEX("明通国际快递", "tnjex"),
    TNTEN("TNT-全球件", "tnten"),
    ALIEXPRESS("无忧物流", "aliexpress"),
    SHUNFENGHK("顺丰-繁体", "shunfenghk"),
    DHLDE("DHL-德国件（DHL Deutschland）", "dhlde"),
    MEIQUICK("美快国际物流", "meiquick"),
    SHUNFENGNL("顺丰-荷兰", "shunfengnl"),
    EMSGUOJI("EMS-国际件", "emsguoji"),
    JGWL("景光物流", "jgwl"),
    TNT("TNT", "tnt"),
    BAISHIGUOJI("百世国际", "baishiguoji"),
    TCAT("黑猫宅急便", "tcat"),
    SUNJEX("新杰物流", "sunjex"),
    YANGBAOGUO("洋包裹", "yangbaoguo"),
    ROKIN("荣庆物流", "rokin"),
    ARKEXPRESS("方舟速递", "arkexpress"),
    SHENGHUIWULIU("盛辉物流", "shenghuiwuliu"),
    BANMA("斑马物流", "banma"),
    ZHUANYUNSIFANG("转运四方", "zhuanyunsifang"),
    TZKY("铁中快运", "tzky"),
    JINDAWULIU("金大物流", "jindawuliu"),
    AAE("AAE-中国件", "aae"),
    FUJISUYUN("富吉速运", "fujisuyun"),
    VIECHINA("佰纳博通", "viechina"),
    STOSOLUTION("申通国际", "stosolution"),
    TIANTIAN("天天快递", "tiantian"),
    BTEXPRESS("邦泰快运", "btexpress"),
    ZHENGYIKUAIDI("鑫正一快递", "zhengyikuaidi"),
    SUPERB("Superb Express", "superb"),
    XIAOMIWULIU("小米物流", "xiaomiwuliu"),
    SYPOST("顺友物流", "sypost"),
    TAIJIN("泰进物流", "taijin"),
    YUANANDA("源安达", "yuananda"),
    SANZHI56("三志物流", "sanzhi56"),
    BOXC("BOXC", "boxc"),
    EMSBG("EMS包裹", "emsbg"),
    HKGLOBALSEA("環海快運", "hkglobalsea"),
    ZTOCC("中通冷链", "ztocc"),
    DEKUNCN("德坤物流", "dekuncn"),
    CHT361("诚和通", "cht361"),
    JAPANPOSTEN("日本（Japan Post）", "japanposten"),
    SJA56("四季安物流", "sja56"),
    NDWL("南方传媒物流", "ndwl"),
    TYKD("天翼快递", "tykd"),
    GOTOUBI("UBI Australia", "gotoubi"),
    OCS("OCS", "ocs"),
    CKEXPRESS("CK物流", "ckexpress"),
    ZHONGSUKUAIDI("中速快递", "zhongsukuaidi"),
    ANJIE88("安捷物流", "anjie88"),
    DOORTODOOR("CJ物流", "doortodoor"),
    YW56("燕文物流", "yw56"),
    GLS("GLS", "gls"),
    DATIANWULIU("大田物流", "datianwuliu"),
    LHEXPRESSUS("联合速递", "lhexpressus"),
    JINGLEEXPRESSX("Jingle Express", "jingleexpressx"),
    SANHUWULIU("叁虎物流", "sanhuwuliu"),
    GOEX("时安达速递", "goex"),
    JUMSTC("聚盟共建", "jumstc"),
    JIAJIWULIU("佳吉快运", "jiajiwuliu"),
    SMWFLOOR("湘粤华通", "smwfloor"),
    LIANBANGKUAIDI("联邦快递", "lianbangkuaidi"),
    CCCC58("中集冷云", "cccc58"),
    CANPOST("加拿大(Canada Post)", "canpost"),
    ZHONGTIEWULIU("中铁飞豹", "zhongtiewuliu"),
    BOYOL("贝业物流", "boyol"),
    JAPANPOST("日本郵便", "japanpost"),
    SZCLYC("车联天下", "szclyc"),
    CTOEXP("泰国中通CTO", "ctoexp"),
    WANJIAWULIU("万家物流", "wanjiawuliu"),
    ARAMEX("Aramex", "aramex"),
    KYRGYZPOST("吉尔吉斯斯坦(Kyrgyz Post)", "kyrgyzpost"),
    FTD("富腾达国际货运", "ftd"),
    NEWSWAY("家家通快递", "newsway"),
    LESOON("丽迅物流", "lesoon"),
    SIGNEDEXPRESS("签收快递", "signedexpress"),
    HUAHANWULIU("华翰物流", "huahanwuliu"),
    HERMES("Hermes", "hermes"),
    UBUY("德国优拜物流", "ubuy"),
    YZTEX("一站通速运", "yztex"),
    JIALIDATONG("嘉里大通", "jialidatong"),
    GAOTIAN56("高田物流", "gaotian56"),
    COM1EXPRESS("商壹国际物流", "com1express"),
    AIRGTC("加拿大民航快递", "airgtc"),
    ZY100("中远快运", "zy100"),
    TAKESEND("泰嘉物流", "takesend"),
    YZSWULIU("亚洲顺物流", "yzswuliu"),
    AUOD("澳德物流", "auod"),
    GUEXP("全联速运", "guexp"),
    SZSHIHUATONG56("世华通物流", "szshihuatong56"),
    JXAD56("成都捷信安达物流", "jxad56"),
    JINYUEKUAIDI("晋越快递", "jinyuekuaidi"),
    USA7EX("美七国际快递", "usa7ex"),
    YAOQI("耀奇物流", "yaoqi"),
    ANXL("安迅物流", "anxl"),
    CRAZYEXPRESS("疯狂快递", "crazyexpress"),
    GAOTIEEX("高铁快运", "gaotieex"),
    ZHONGYOUWULIU("中邮物流", "zhongyouwuliu"),
    YUEJIUTONG("粤九通物流", "yuejiutong"),
    GZXINGCHENG("贵州星程快递", "gzxingcheng"),
    SHENJUN("神骏物流", "shenjun"),
    GANZHONGNENGDA("能达速递", "ganzhongnengda"),
    TIANDIHUAYU("天地华宇", "tiandihuayu"),
    JIAYIWULIU("佳怡物流", "jiayiwuliu"),
    ANJIEKUAIDI("青岛安捷快递", "anjiekuaidi"),
    LA911("鼎润物流", "la911"),
    ANXINDAKUAIXI("安信达", "anxindakuaixi"),
    MEXPRESS("百米快运", "100mexpress"),
    HENGLUWULIU("恒路物流", "hengluwuliu"),
    LTEXP("乐天速递", "ltexp"),
    EMSINTEN("EMS-国际件-英文", "emsinten"),
    POSTSERV("中华邮政", "postserv"),
    CKEEX("城晓国际快递", "ckeex"),
    ZLINK("三真驿道", "zlink"),
    UNITEDEX("联合速运", "unitedex"),
    DPDGERMANY("DPD Germany", "dpdgermany"),
    USZCN("转运中国", "uszcn"),
    HXLINC("华兴物流", "hxlinc"),
    SYNSHIP("SYNSHIP快递", "synship"),
    BIAOJIKUAIDI("彪记快递", "biaojikuaidi"),
    DPDUK("DPD UK", "dpduk"),
    NZZTO("新西兰中通", "nzzto"),
    HUOLALAWULIU("货拉拉物流", "huolalawuliu"),
    POSTNL("荷兰邮政(PostNL international registered mail)", "postnl"),
    TIANMA("天马迅达", "tianma"),
    HNHT56("鸿泰物流", "hnht56"),
    KUAIJIESUDI("快捷速递", "kuaijiesudi"),
    FARDARWW("颿达国际快递", "fardarww"),
    HANJIN("Hanjin", "hanjin"),
    DFWL("达发物流", "dfwl"),
    ZTEEXPRESS("ZTE中兴物流", "zteexpress"),
    HAIWAIHUANQIU("海外环球", "haiwaihuanqiu"),
    SENDTOCHINA("速递中国", "sendtochina"),
    TNTITALY("TNT Italy", "tntitaly"),
    JTEXPRESSEG("极兔快递埃及站", "jtexpresseg"),
    SWISHIPUS("swiship us", "swishipus"),
    COE("COE", "coe"),
    KHZTO("柬埔寨中通", "khzto"),
    XGDD56("星光大道", "xgdd56"),
    STOEXPRESS("美国申通", "stoexpress"),
    LOTTEGLOGIS("lotteglogis", "lotteglogis"),
    MORELINK56("MoreLink", "morelink56"),
    WORLDEX("世通物流", "worldex"),
    XYNYC("新元国际", "xynyc"),
    ERQIANJIA56("贰仟家物流", "erqianjia56"),
    GDJIDA56("继达物流", "gdjida56"),
    YDHEX("YDH", "ydhex"),
    NANTIANWULIU("南天物流", "nantianwuliu"),
    CHUKOU1("出口易", "chukou1"),
    WEITEPAI("微特派", "weitepai"),
    CHANGYOUSUDI("畅邮速递", "changyousudi"),
    UBONEX("优邦速运", "ubonex"),
    VALUEWAY("美通", "valueway"),
    AUSPOST("澳大利亚(Australia Post)", "auspost"),
    GDKJK56("快捷快物流", "gdkjk56"),
    MACAO("中国澳门(Macau Post)", "macao"),
    STONEWZEALAND("申通新西兰", "stonewzealand"),
    MLW("美乐维冷链物流", "mlw"),
    AOTSD("澳天速运", "aotsd"),
    KEJIE("科捷物流", "kejie"),
    ADAPOST("安达速递", "adapost"),
    LIJISONG("成都立即送", "lijisong"),
    DONGJUN("成都东骏物流", "dongjun"),
    ILOGEN("logen路坚", "ilogen"),
    HUIF56("汇峰物流", "huif56"),
    TTKEUROPE("天天欧洲物流", "ttkeurope"),
    DADAOEX("大道物流", "dadaoex"),
    PMT0704BE("龙行天下", "pmt0704be"),
    JINAN("金岸物流", "jinan"),
    JIAXIANWULIU("嘉贤物流", "jiaxianwuliu"),
    FASTGOEXPRESS("速派快递", "fastgoexpress"),
    KUAIJIEWULIU("快捷物流", "kuaijiewuliu"),
    GUANGDONGYOUZHENGWULIU("广东邮政", "guangdongyouzhengwuliu"),
    LONGCPS("加拿大龙行速运", "longcps"),
    FTKY365("丰通快运", "ftky365"),
    SXEXPRESS("三象速递", "sxexpress"),
    FENGHUANGKUAIDI("凤凰快递", "fenghuangkuaidi"),
    GLOBAL99("全球速运", "global99"),
    DSUKUAIDI("D速快递", "dsukuaidi"),
    PARCELFORCECN("英国邮政大包EMS", "parcelforcecn"),
    YUANFEIHANGWULIU("原飞航", "yuanfeihangwuliu"),
    BJEMSTCKJ("北京EMS", "bjemstckj"),
    PASSERBYAEXPRESS("顺捷美中速递", "passerbyaexpress"),
    LINGSONG("领送送", "lingsong"),
    CQXINGCHENG("重庆星程快递", "cqxingcheng"),
    HAOXIANGWULIU("豪翔物流", "haoxiangwuliu"),
    SZYOUZHENG("深圳邮政", "szyouzheng"),
    XDEXPRESS("迅达速递", "xdexpress"),
    UCS("合众速递(UCS）", "ucs"),
    JSCPL("江苏中邮", "jscpl"),
    LESHINES("想乐送", "leshines"),
    WULIUKY("五六快运", "wuliuky"),
    LNET("新易泰", "lnet"),
    PARCELFORCE("英国大包、EMS（Parcel Force）", "parcelforce"),
    BECKYGO("佰麒快递", "beckygo"),
    QBEXPRESS("秦邦快运", "qbexpress"),
    HDCEXPRESS("汇达物流", "hdcexpress"),
    CHINAPOSTCB("中邮电商", "chinapostcb"),
    FEDEXUS("FedEx-美国件", "fedexus"),
    TSTEXP("TST速运通", "tstexp"),
    WONDERSYD("中邮速递", "wondersyd"),
    SHUNJIEDA("顺捷达", "shunjieda"),
    TONGSHENGWJ("通胜物流", "tongshengwj"),
    SUNDAREXPRESS("顺达快递", "sundarexpress"),
    CHANGWOOAIR("昌宇国际", "changwooair"),
    QUANYIKUAIDI("全一快递", "quanyikuaidi"),
    BRT("BRT", "brt"),
    SZUEM("联运通物流", "szuem"),
    QINLING("秦岭智能速运", "qinling"),
    CYXFX("小飞侠速递", "cyxfx"),
    MYHERMES("MyHermes", "myhermes"),
    SINOEX("中外运速递-中文", "sinoex"),
    POLAREXPRESS("极地快递", "polarexpress"),
    JTEXPRESSSG("J&T Express 新加坡", "jtexpresssg"),
    YOUYOU("优优速递", "youyou"),
    CORREOS("哥斯达黎加(Correos de Costa Rica)", "correos"),
    BAIFUDONGFANG("百福东方", "baifudongfang"),
    GZANJCWL("广州安能聚创物流", "gzanjcwl"),
    KOALAEXP("考拉速递", "koalaexp"),
    CNEXPS("CNE", "cnexps"),
    XLOBO("Xlobo贝海国际", "xlobo"),
    TMWEXPRESS("明达国际速递", "tmwexpress"),
    YAOFEIKUAIDI("耀飞同城快递", "yaofeikuaidi"),
    WTDCHINA("威时沛运货运", "wtdchina"),
    YUANDUN("远盾物流", "yuandun"),
    YUJIAWL("宇佳物流", "yujiawl"),
    CHINASTARLOGISTICS("华欣物流", "chinastarlogistics"),
    SPRING56("春风物流", "spring56"),
    YUANCHENGWULIU("远成物流", "yuanchengwuliu"),
    CHUANXIWULIU("传喜物流", "chuanxiwuliu"),
    JIUJIUWL("久久物流", "jiujiuwl"),
    YNZTSY("黑猫同城送", "ynztsy"),
    QUANFENGKUAIDI("全峰快递", "quanfengkuaidi"),
    LIZHAN("力展物流", "lizhan"),
    ONEEXPRESS("一速递", "oneexpress"),
    YTCHENGNUODA("承诺达", "ytchengnuoda"),
    EPANEX("泛捷国际速递", "epanex"),
    HZDR("天鸽快运", "hzdr"),
    SFC("SFC", "sfc"),
    SHILIGYL("实利配送", "shiligyl"),
    FEIKUAIDA("飞快达", "feikuaida"),
    CCD("次晨达物流", "ccd"),
    EMSEN("EMS-英文", "emsen"),
    CSUIVI("法国(La Poste)", "csuivi"),
    SANTAISUDI("三态速递", "santaisudi"),
    YOUSUTONGDA("优速通达", "yousutongda"),
    KEYPON("启邦国际物流", "keypon"),
    SDTO("速达通", "sdto"),
    EXSUDA("E速达", "exsuda"),
    XINMENGCHENG("鑫梦成", "xinmengcheng"),
    TUNISIA("突尼斯EMS(Rapid-Poste)", "tunisia"),
    AIRPAK("airpak expresss", "airpak"),
    SD138("泰国138国际物流", "sd138"),
    CONCARE("中健云康", "concare"),
    XLAIR("快弟来了", "xlair"),
    PJBEST("品骏快递", "pjbest"),
    JSDKY("极速达物流", "jsdky"),
    SGXPRESS("SGXpress", "sgxpress"),
    CITY56("城市映急", "city56"),
    CJKOREAEXPRESS("大韩通运", "cjkoreaexpress"),
    LBC56("LBC Express", "lbc56"),
    CHRONOPOSTFRA("法国大包、EMS-法文（Chronopost France）", "chronopostfra"),
    CNSPEEDSTER("速舟物流", "cnspeedster"),
    JET("极兔国际", "jet"),
    DI5PLL("递五方云仓", "di5pll"),
    ENGLAND("英国(大包,EMS)", "england"),
    ZHONGHUAN("中环快递", "zhonghuan"),
    EUASIA("欧亚专线", "euasia"),
    KINGFREIGHT("货运皇", "kingfreight"),
    PDSTOW("全球速递", "pdstow"),
    TENGDAWL("腾达物流", "tengdawl"),
    AZERBAIJAN("阿塞拜疆EMS(EMS AzerExpressPost)", "azerbaijan"),
    CAIFENGWL("彩丰物流", "caifengwl"),
    CHRONOPOSTFREN("法国大包、EMS-英文(Chronopost France)", "chronopostfren"),
    VNPOST("越南EMS(VNPost Express)", "vnpost"),
    ELTAHELL("希腊EMS（ELTA Courier）", "eltahell"),
    SPEEDPOST("新加坡EMS、大包(Singapore Speedpost)", "speedpost"),
    CFSS("银雁专送", "cfss"),
    EMSUKRAINE("乌克兰EMS(EMS Ukraine)", "emsukraine"),
    EMSUKRAINECN("乌克兰EMS-中文(EMS Ukraine)", "emsukrainecn"),
    INDONESIA("印度尼西亚EMS(Pos Indonesia-EMS)", "indonesia"),
    JIUYESCM("九曳供应链", "jiuyescm"),
    PUROLATOR("Purolator", "purolator"),
    TNTAU("TNT Australia", "tntau"),
    EMSSOUTHAFRICA("南非EMS", "emssouthafrica"),
    JIACHENG("佳成快递", "jiacheng"),
    A2U("A2U速递", "a2u"),
    EMMS("澳州顺风快递", "emms"),
    QESD("7E速递", "qesd"),
    TCXBTHAI("GPI", "tcxbthai"),
    BLEX56("奔力物流", "blex56"),
    HTTX56("汇通天下物流", "httx56"),
    MINGHANGKUAIDI("民航快递", "minghangkuaidi"),
    PFCEXPRESS("皇家物流", "pfcexpress"),
    ZITON("一智通", "1ziton"),
    QUANXINTONG("全信通快递", "quanxintong"),
    JSSDT56("时达通", "jssdt56"),
    DHLHK("DHL HK", "dhlhk"),
    EFSPOST("EFSPOST", "efspost"),
    LANDMARKGLOBAL("Landmark Global", "landmarkglobal"),
    LX56("龙兴物流", "lx56"),
    XIANGYUWL56("翔宇物流", "xiangyuwl56"),
    TJKJWL("泰实货运", "tjkjwl"),
    WXGBWL("广博物流", "wxgbwl"),
    YUANSUHY("鸢速货运", "yuansuhy"),
    AOLAU("AOL澳通速递", "aolau"),
    EXPRESS2GLOBAL("E2G速递", "express2global"),
    XINNING("新宁物流", "xinning"),
    EUPACKAGE("易优包裹", "eupackage"),
    HIGHSINCE("海欣斯快递", "highsince"),
    SHIPGCE("飞洋快递", "shipgce"),
    ZTWLGYL("中铁物流供应链", "ztwlgyl"),
    EFS("EFS Post（平安快递）", "efs"),
    ITALIANE("意大利(Poste Italiane)", "italiane"),
    SUNSPEEDY("新速航", "sunspeedy"),
    USCBEXPRESS("易境达国际物流", "uscbexpress"),
    BUYER1688("1688国际物流", "buyer1688"),
    DISIFANGUS("递四方美国", "disifangus"),
    GUANGDONGTONGLU("广东通路", "guangdongtonglu"),
    LITE56("Lite Express", "lite56"),
    NEZHASUYUN("哪吒速运", "nezhasuyun"),
    RLGAUS("澳洲飞跃物流", "rlgaus"),
    ZHONGJI("中汲物流", "zhongji"),
    FBKD("飞邦快递", "fbkd"),
    SHANGQIAO56("商桥物流", "shangqiao56"),
    CHINAICIP("卓志速运", "chinaicip"),
    COLISSIMO("法国小包（colissimo）", "colissimo"),
    DPEX("DPEX", "dpex"),
    FEIBAOKUAIDI("飞豹快递", "feibaokuaidi"),
    HOMECOURIER("如家国际快递", "homecourier"),
    HUANGMAJIA("黄马甲", "huangmajia"),
    INTERJZ("捷运达快递", "interjz"),
    JIACHENEXPRESS("佳辰国际速递", "jiachenexpress"),
    NINJAVAN("Ninja Van", "ninjavan"),
    RRSKX("日日顺快线", "rrskx"),
    SZXPWL("兴鹏物流", "szxpwl"),
    BELGIUMPOST("比利时(Belgium Post)", "belgiumpost"),
    GIBRALTAR("直布罗陀[英国]( Royal Gibraltar Post)", "gibraltar"),
    HJWL("汇捷物流", "hjwl"),
    HKPOST("中国香港(HongKong Post)", "hkpost"),
    JTEXPRESSPH("J&T Express 菲律宾", "jtexpressph"),
    JTEXPRESSTH("J&T Express 泰国", "jtexpressth"),
    SXHONGMAJIA("红马甲物流", "sxhongmajia"),
    TIANCHENWULIU("天辰物流", "tianchenwuliu"),
    TJLYZ56("老扬州物流", "tjlyz56"),
    ZRTL("中融泰隆", "zrtl"),
    CJQY("长吉物流", "cjqy"),
    MINGLIANGWULIU("明亮物流", "mingliangwuliu"),
    TAOTE("淘特物流快递", "taote"),
    XHF56("鑫宏福物流", "xhf56"),
    ZHONGXINDA("忠信达", "zhongxinda"),
    KOREAPOST("韩国（Korea Post）", "koreapost"),
    XSRD("鑫世锐达", "xsrd"),
    CHANGJIANG("长江国际速递", "changjiang"),
    DHLUK("dhluk", "dhluk"),
    JDIEX("JDIEX", "jdiex"),
    LANJUNSUYUN("岚骏速运", "lanjunsuyun"),
    SHLINDAO("林道国际快递", "shlindao"),
    WJKWL("万家康物流", "wjkwl"),
    YUANZHIJIECHENG("元智捷诚", "yuanzhijiecheng"),
    CHSZHONGHUANGUOJI("CHS中环国际快递", "chszhonghuanguoji"),
    GXWL("光线速递", "gxwl"),
    HUANQIUABC("中国香港环球快运", "huanqiuabc"),
    ITALYSAD("Italy SDA", "italysad"),
    JUDING("聚鼎物流", "juding"),
    UEQ("UEQ快递", "ueq"),
    ZTCCE("中途速递", "ztcce"),
    HEIBAOWULIU("黑豹物流", "heibaowuliu"),
    HKEMS("云邮跨境快递", "hkems"),
    KSUDI("快速递", "ksudi"),
    YCGKY("远成快运", "ycgky"),
    YIDATONG("易达通", "yidatong"),
    CHENGTONG("城通物流", "chengtong"),
    FT56("飞腾物流", "ft56"),
    GTS("GTS快递", "gts"),
    HAIDAIBAO("海带宝", "haidaibao"),
    HYWULIU("中电华远物流", "hywuliu"),
    KOREAPOSTCN("韩国邮政", "koreapostcn"),
    TCXFX("正鑫小飞侠", "tcxfx"),
    BEEBIRD("锋鸟物流", "beebird"),
    DPDPOLAND("DPD Poland", "dpdpoland"),
    POSTNLCN("荷兰邮政-中文(PostNL international registered mail)", "postnlcn"),
    YUEFENGWULIU("越丰物流", "yuefengwuliu"),
    DAYANGWULIU("大洋物流", "dayangwuliu"),
    FLYSMAN("飞力士物流", "flysman"),
    HKPOSTEN("中国香港(HongKong Post)英文", "hkposten"),
    JIXIANDA("急先达", "jixianda"),
    KERRYTJ("嘉里大荣物流", "kerrytj"),
    SDSY888("首达速运", "sdsy888"),
    XUNSUEXPRESS("迅速快递", "xunsuexpress"),
    ZTJIEDA("泰捷达国际物流", "ztjieda"),
    ZTSDU("中途国际速递", "ztsdu"),
    ABF("ABF", "abf"),
    BUFFALOEX("Buffalo", "buffaloex"),
    DANDE56("丹递56", "dande56"),
    YAFENGSUDI("亚风速递", "yafengsudi"),
    YODEL("YODEL", "yodel"),
    YOUJIA("友家速递", "youjia"),
    ICELAND("冰岛(Iceland Post)", "iceland"),
    NEWZEALAND("新西兰（New Zealand Post）", "newzealand"),
    POSTNLPACLE("荷兰包裹(PostNL International Parcels)", "postnlpacle"),
    QUANSU("全速物流", "quansu"),
    BAISHIYP("百世云配", "baishiyp"),
    BUYTONG("百通物流", "buytong"),
    EST365("东方汇", "est365"),
    FEIKANGDA("飞康达", "feikangda"),
    HOTWMS("皇家云仓", "hotwms"),
    IBUY8("爱拜物流", "ibuy8"),
    JINGSHUN("景顺物流", "jingshun"),
    MOSUDA("魔速达", "mosuda"),
    AUVEXPRESS("AUV国际快递", "auvexpress"),
    CANPOSTFR("加拿大邮政", "canpostfr"),
    CNPEX("CNPEX中邮快递", "cnpex"),
    GE2D("GE2D跨境物流", "ge2d"),
    GONGSUDA("共速达", "gongsuda"),
    SCZPDS("速呈", "sczpds"),
    SHUANGHE("双鹤物流", "shuanghe"),
    SHUNJIEFENGDA("顺捷丰达", "shunjiefengda"),
    XIANGTENG("翔腾物流", "xiangteng"),
    ZHIGUIL("智谷特货", "zhiguil"),
    HREX("锦程快递", "hrex"),
    SUJIEVIP("郑州速捷", "sujievip"),
    EMSLUQU("高考通知书", "emsluqu"),
    ETEENLOG("ETEEN专线", "eteenlog"),
    GFDWULIU("冠达丰物流", "gfdwuliu"),
    HANGRUI("上海航瑞货运", "hangrui"),
    LINEX("Linex", "linex"),
    WXYUANHUI("远辉物流", "wxyuanhui"),
    YHTLOGISTICS("宇航通物流", "yhtlogistics"),
    ZSDA56("转瞬达集运", "zsda56"),
    ALFATREX("AlfaTrex", "alfatrex"),
    BFLG("上海缤纷物流", "bflg"),
    CDXINCHEN56("鑫宸物流", "cdxinchen56"),
    CNAUSU("中澳速递", "cnausu"),
    DEUTSCHEPOST("德国(Deutsche Post)", "deutschepost"),
    FLYWAY("程光快递", "flyway"),
    HNFY("飞鹰物流", "hnfy"),
    JIEANDA("捷安达", "jieanda"),
    JTEXPRESSMY("J&T Express 马来西亚", "jtexpressmy"),
    LFEXPRESS("龙枫国际快递", "lfexpress"),
    ONTRAC("OnTrac", "ontrac"),
    QINYUAN("秦远物流", "qinyuan"),
    QZX56("全之鑫物流", "qzx56"),
    SHENGANWULIU("圣安物流", "shenganwuliu"),
    SZDPEX("深圳DPEX", "szdpex"),
    WINIT("万邑通", "winit"),
    XIYOUG("西游寄", "xiyoug"),
    XSB56("鑫圣邦物流", "xsb56"),
    YIJIANGKY("驿将快运", "yijiangky"),
    YLKSWL("亚历克斯供应链", "ylkswl"),
    LION("360 Lion Express", "360lion"),
    AAACOOPER("AAA Cooper Transportation", "aaacooper"),
    ADP("ADP国际快递", "adp"),
    ANPOSTEN("爱尔兰(An Post)", "anposten"),
    BANGSONGWULIU("邦送物流", "bangsongwuliu"),
    BSHT("百事亨通", "bsht"),
    DHLBENELUX("DHL Benelux", "dhlbenelux"),
    HLTOP("海联快递", "hltop"),
    JCSUDA("嘉诚速达", "jcsuda"),
    KOREAPOSTKR("韩国邮政韩文", "koreapostkr"),
    KUAIKA("快卡", "kuaika"),
    ZHONGHUANUS("中环转运", "zhonghuanus"),
    ZTONG("智通物流", "ztong"),
    ADAEXPRESS("明大快递", "adaexpress"),
    AHDF("德方物流", "ahdf"),
    CORREOSDEES("西班牙(Correos de Espa?a)", "correosdees"),
    CPSAIR("华中快递", "cpsair"),
    DFPOST("达方物流", "dfpost"),
    FASTWAY("Fastway Ireland", "fastway"),
    FLASHEXPRESS("Flash Express", "flashexpress"),
    GATIEN("Gati-英文", "gatien"),
    GDQWWL("全网物流", "gdqwwl"),
    JIAJIKUAIDI("佳吉快递", "jiajikuaidi"),
    MEIXI("美西快递", "meixi"),
    POSTNLCHINA("荷兰邮政-中国件", "postnlchina"),
    QUANRITONGKUAIDI("全日通", "quanritongkuaidi"),
    XQD4000711238("新骐点物流", "xqd4000711238"),
    YOUBAN("邮邦国际", "youban"),
    YTKY168("运通快运", "ytky168"),
    YUE777("玥玛速运", "yue777"),
    ZJGJ56("振捷国际货运", "zjgj56"),
    AUEX("澳货通", "auex"),
    CESKAPOSTA("捷克（?eská po?ta）", "ceskaposta"),
    FLASHEXPRESSEN("Flash Express-英文", "flashexpressen"),
    GUOERYUE("天天快物流", "guoeryue"),
    HMUS("华美快递", "hmus"),
    KANGRUN("康润物流", "kangrun"),
    MALAYSIAEMS("马来西亚大包、EMS（Malaysia Post(parcel,EMS)）", "malaysiaems"),
    MEIDAEXPRESS("美达快递", "meidaexpress"),
    QUANTIUM("Quantium", "quantium"),
    SCXINGCHENG("四川星程快递", "scxingcheng"),
    TONGHETIANXIA("通和天下", "tonghetianxia"),
    UKRPOSTCN("乌克兰邮政包裹", "ukrpostcn"),
    XYJEXPRESS("西邮寄速递", "xyjexpress"),
    YIQISONG("一起送", "yiqisong"),
    ZHONGHONGWL("中宏物流", "zhonghongwl"),
    ACOMMERCE("aCommerce", "acommerce"),
    ACSCOURIER("ACS Courier", "acscourier"),
    ASENDIAUSA("Asendia USA", "asendiausa"),
    ASTEXPRESS("安世通快递", "astexpress"),
    AUSTRIA("奥地利(Austrian Post)", "austria"),
    BHT("BHT", "bht"),
    BRAZILPOSTEN("巴西(Brazil Post/Correios)", "brazilposten"),
    DECHUANGWULIU("深圳德创物流", "dechuangwuliu"),
    DPEXEN("Toll", "dpexen"),
    DYBSERVICE("DYB", "dybservice"),
    EDRAGON("龙象国际物流", "edragon"),
    FANQIU("泛球物流", "fanqiu"),
    FEDROAD("FedRoad 联邦转运", "fedroad"),
    HGY56("环国运物流", "hgy56"),
    HKHUAGUANG("华光国际快运", "hkhuaguang"),
    HUANQIU("环球速运", "huanqiu"),
    HUIQIANGKUAIDI("汇强快递", "huiqiangkuaidi"),
    KOALI("番薯国际货运", "koali"),
    LMFEX("良藤国际速递", "lmfex"),
    LONGFX("LUCFLOW EXPRESS", "longfx"),
    SAIAODIMMB("赛澳递for买卖宝", "saiaodimmb"),
    SHANGCHENG("尚橙物流", "shangcheng"),
    STKD("顺通快递", "stkd"),
    WANDOUGONGZHU("豌豆物流", "wandougongzhu"),
    WANJIATONG("万家通急送", "wanjiatong"),
    YDGLOBE("云达通", "ydglobe"),
    ZHONGJIWULIU("中技物流", "zhongjiwuliu"),
    ZSMHWL("明辉物流", "zsmhwl"),
    ADLERLOGI("德国雄鹰速递", "adlerlogi"),
    ANMIN56("安敏物流", "anmin56"),
    ANSHIDI("安时递", "anshidi"),
    ASENDIA("阿森迪亚", "asendia"),
    BHUTAN("不丹邮政 Bhutan Post", "bhutan"),
    CHENGJI("城际快递", "chengji"),
    COLOMBIA("哥伦比亚(4-72 La Red Postal de Colombia)", "colombia"),
    DIANYI("云南滇驿物流", "dianyi"),
    FIRSTFLIGHT("First Flight", "firstflight"),
    HAIHONGMMB("海红for买卖宝", "haihongmmb"),
    HNYQF("益企发物流", "hnyqf"),
    HPEXPRESS("海派国际速递", "hpexpress"),
    HUILIN56("汇霖大货网", "huilin56"),
    HYYTES("恒宇运通", "hyytes"),
    JCEX("jcex", "jcex"),
    KFWNET("快服务", "kfwnet"),
    LINEONE("一号线", "lineone"),
    LSEXPRESS("6LS EXPRESS", "lsexpress"),
    LUCKYFASTEX("吉捷国际速递", "luckyfastex"),
    PORTUGALCTT("葡萄牙（Portugal CTT）", "portugalctt"),
    POSTENAB("PostNord(Posten AB)", "postenab"),
    POSTNORD("PostNord Logistics", "postnord"),
    RENRENEX("人人转运", "renrenex"),
    SINGPOST("新加坡小包(Singapore Post)", "singpost"),
    SIXROAD("易普递", "sixroad"),
    SOUTHAFRICAN("南非（South African Post Office）", "southafrican"),
    SSD("速速达", "ssd"),
    THAILAND("泰国邮政（Thailand Thai Post）", "thailand"),
    WENJIESUDI("文捷航空", "wenjiesudi"),
    WUYUANSUDI("伍圆速递", "wuyuansudi"),
    YIZHENGDASUYUN("一正达速运", "yizhengdasuyun"),
    YJHGO("武汉优进汇", "yjhgo"),
    YUFENG("御风速运", "yufeng"),
    ZBHY56("浩运物流", "zbhy56"),
    ZHONGTIANWANYUN("中天万运", "zhongtianwanyun"),
    ZSKY123("准实快运", "zsky123"),
    ZYZOOM("增速跨境", "zyzoom"),
    AFGHAN("阿富汗(Afghan Post)", "afghan"),
    BAOXIANDA("报通快递", "baoxianda"),
    BENTENG("奔腾物流", "benteng"),
    BJYTSYWL("远通盛源", "bjytsywl"),
    BPOSTINTER("比利时国际(Bpost international)", "bpostinter"),
    CARGOLUX("卢森堡航空", "cargolux"),
    CHLLOG("嘉荣物流", "chllog"),
    CHUANGYI("创一快递", "chuangyi"),
    CLLEXPRESS("澳通华人物流", "cllexpress"),
    DIDASUYUN("递达速运", "didasuyun"),
    EALCEAIR("东方航空物流", "ealceair"),
    FINLAND("芬兰(Itella Posti Oy)", "finland"),
    HUADA("华达快运", "huada"),
    IDADA("大达物流", "idada"),
    ITAOEXPRESS("爱淘速递", "itaoexpress"),
    JTEXPRESSAE("极兔快递阿联酋", "jtexpressae"),
    JUMSZ("聚盟物流", "jumsz"),
    LANHUKUAIDI("蓝弧快递", "lanhukuaidi"),
    LIANYUN("联运快递", "lianyun"),
    LUCKYEXPRESS("吉运家物流", "luckyexpress"),
    NUOKELAI("诺客来", "nuokelai"),
    QIANLI("千里速递", "qianli"),
    SFIFT("十方通物流", "sfift"),
    SHANGDA("上大物流", "shangda"),
    SHININGEXPRESS("阳光快递", "shiningexpress"),
    SWISSPOST("瑞士(Swiss Post)", "swisspost"),
    SWISSPOSTCN("瑞士邮政", "swisspostcn"),
    SZYUDAWL("宇达物流", "szyudawl"),
    UKRAINE("乌克兰小包、大包(UkrPoshta)", "ukraine"),
    XFLT56("蓝天物流", "xflt56"),
    YATFAI("一辉物流", "yatfai"),
    YIEX("宜送物流", "yiex"),
    ZHITENGWULIU("志腾物流", "zhitengwuliu"),
    ZHONGKUAI("中快货运", "zhongkuai"),
    ABS("ABS courier & freight system", "abs"),
    AGOPOST("全程快递", "agopost"),
    ALOG("心怡物流", "alog"),
    AMAZONCNORDER("亚马逊中国订单", "amazoncnorder"),
    APGECOMMERCE("apgecommerce", "apgecommerce"),
    BJQYWL("青云物流", "bjqywl"),
    CAMBODIA("柬埔寨(Cambodia Post)", "cambodia"),
    CD3FWL("中迅三方", "cd3fwl"),
    CNUP("CNUP 中联邮", "cnup"),
    DFLOGIS("DFGL", "dflogis"),
    DHLECOMMERCE("dhl小包", "dhlecommerce"),
    EXBTR("飛斯特運通", "exbtr"),
    FOX("FOX国际快递", "fox"),
    GDXP("新鹏快递", "gdxp"),
    GHTEXPRESS("GHT物流", "ghtexpress"),
    GRIVERTEK("潍鸿", "grivertek"),
    HEIMAO56("黑猫速运", "heimao56"),
    HONGPINWULIU("宏品物流", "hongpinwuliu"),
    HUANDONGLG("环东物流", "huandonglg"),
    IPARCEL("UPS i-parcel", "iparcel"),
    JDEXPRESSUSA("骏达快递", "jdexpressusa"),
    JIAJIAWL("加佳物流", "jiajiawl"),
    JINCHENGWULIU("锦程物流", "jinchengwuliu"),
    JJX888("佳捷翔物流", "jjx888"),
    JUNFENGGUOJI("骏丰国际速递", "junfengguoji"),
    JUZHONGDA("聚中大", "juzhongda"),
    KCS("KCS", "kcs"),
    KUAIDAWULIU("快达物流", "kuaidawuliu"),
    LDXPRES("林道国际快递-英文", "ldxpres"),
    MAURITIUS("毛里求斯(Mauritius Post)", "mauritius"),
    MCIH("MCIH国际快递", "mcih"),
    NAMIBIA("纳米比亚(NamPost)", "namibia"),
    POSTDANMARKEN("丹麦(Post Denmark)", "postdanmarken"),
    QSKDYXGS("千顺快递", "qskdyxgs"),
    RUIDIANYOUZHENG("瑞典（Sweden Post）", "ruidianyouzheng"),
    RUNHENGFENG("全时速运", "runhengfeng"),
    SHANHUODIDI("闪货极速达", "shanhuodidi"),
    SHIYUNKUAIDI("世运快递", "shiyunkuaidi"),
    SINOAIRINEX("中外运空运", "sinoairinex"),
    SUIJIAWULIU("穗佳物流", "suijiawuliu"),
    SUPINEXPRESS("速品快递", "supinexpress"),
    SUTONGST("速通国际快运", "sutongst"),
    TIANZONG("天纵物流", "tianzong"),
    UEX("UEX国际物流", "uex"),
    WXJZWL("九洲物流", "wxjzwl"),
    XHONGDA56("新宏达物流", "xhongda56"),
    XILAIKD("西安喜来快递", "xilaikd"),
    YIOUZHOU("易欧洲国际物流", "yiouzhou"),
    YOSEUS("优胜国际速递", "yoseus"),
    YOULAI("邮来速递", "youlai"),
    YOURSCM("雅澳物流", "yourscm"),
    YYQC56("一运全成物流", "yyqc56"),
    ZAMPOST("赞比亚", "zampost"),
    ZHUOSHIKUAIYUN("卓实快运", "zhuoshikuaiyun"),
    ADIEXPRESS("安达易国际速递", "adiexpress"),
    ADSONE("ADSone", "adsone"),
    ALAND("奥兰群岛", "aland"),
    ALGERIA("Algeria", "algeria"),
    ANLEXPRESS("新干线快递", "anlexpress"),
    AOSU("澳速物流", "aosu"),
    ARIESFAR("艾瑞斯远", "ariesfar"),
    ASENDIAHK("Asendia HK", "asendiahk"),
    AUADEXPRESS("澳达国际物流", "auadexpress"),
    AUSTA("Austa国际速递", "austa"),
    AUTW("澳台转运", "autw"),
    AXEXPRESS("澳新物流", "axexpress"),
    BDATONG("八达通", "bdatong"),
    BEE001("蜜蜂速递", "bee001"),
    BELPOST("白俄罗斯(Belpochta)", "belpost"),
    BESTER("飛斯特", "bester"),
    BJLGYT("路港易通", "bjlgyt"),
    BLJT56("佰乐捷通", "bljt56"),
    BMXPS("北美国际物流", "bmxps"),
    BPHCHINA("速方(Sufast)", "bphchina"),
    BRIEMS("宏桥国际物流", "briems"),
    CANHOLD("能装能送", "canhold"),
    CBLLOGISTICS("广州信邦", "cbllogistics"),
    CDJX56("捷祥物流", "cdjx56"),
    CEVA("CEVA Logistics", "ceva"),
    CEX("城铁速递", "cex"),
    CHENGYANGEX("程洋快递", "chengyangex"),
    CNCEXP("C&C国际速递", "cncexp"),
    DECNLH("德中快递", "decnlh"),
    DEKSU("德速电商物流", "deksu"),
    DELTEC("Deltec Courier", "deltec"),
    DFGLOBALEX("东风全球速递", "dfglobalex"),
    DHLNETHERLANDS("DHL-荷兰（DHL Netherlands）", "dhlnetherlands"),
    DINGDONG("叮咚快递", "dingdong"),
    DSV("DSV", "dsv"),
    DT8ANG("德淘邦", "dt8ang"),
    EASYEXPRESS("EASY EXPRESS", "easyexpress"),
    EDAEUEXPRESS("易达快运", "edaeuexpress"),
    EMONITORINGEN("波兰小包(Poczta Polska)", "emonitoringen"),
    EPSPOST("联众国际", "epspost"),
    ESHUNDA("俄顺达", "eshunda"),
    FANDAGUOJI("颿达国际快递-英文", "fandaguoji"),
    FASTONTIME("加拿大联通快运", "fastontime"),
    FASTZT("正途供应链", "fastzt"),
    FEIHUKUAIDI("飞狐快递", "feihukuaidi"),
    GDCT56("广东诚通物流", "gdct56"),
    GDEX("GDEX", "gdex"),
    GML("英脉物流", "gml"),
    GOLDJET("高捷快运", "goldjet"),
    GSM("GSM", "gsm"),
    GTTEXPRESS("GTT EXPRESS快递", "gttexpress"),
    H66("货六六", "h66"),
    HANDBOY("汉邦国际速递", "handboy"),
    HENGRUI56("恒瑞物流", "hengrui56"),
    HEXINEXPRESS("合心速递", "hexinexpress"),
    HLYEX("好来运", "hlyex"),
    HNQST("河南全速通", "hnqst"),
    HONGBEIXIN("红背心", "hongbeixin"),
    HONGYUNFA56("宏运发物流", "hongyunfa56"),
    HONGYWL("红远物流", "hongywl"),
    HRVATSKA("克罗地亚（Hrvatska Posta）", "hrvatska"),
    HUOBAN("兰州伙伴物流", "huoban"),
    HYESHIP("鸿远物流", "hyeship"),
    INDIA("印度(India Post)", "india"),
    JETEXPRESSGROUP("澳速通国际速递", "jetexpressgroup"),
    JIGUANG("极光转运", "jiguang"),
    KAZPOST("哈萨克斯坦(Kazpost)", "kazpost"),
    LANBIAOKUAIDI("蓝镖快递", "lanbiaokuaidi"),
    LASERSHIP("LaserShip", "lasership"),
    LIBANPOST("黎巴嫩(Liban Post)", "libanpost"),
    LONGLANGKUAIDI("隆浪快递", "longlangkuaidi"),
    LONGVAST("长风物流", "longvast"),
    LTPARCEL("联通快递", "ltparcel"),
    LUTONG("鲁通快运", "lutong"),
    LUYAO("路遥物流", "luyao"),
    MALAYSIAPOST("马来西亚小包（Malaysia Post(Registered)）", "malaysiapost"),
    MAXEEDEXPRESS("澳洲迈速快递", "maxeedexpress"),
    MECS("Middle East Courier service", "mecs"),
    MONGOLPOST("蒙古国(Mongol Post)", "mongolpost"),
    NLE("NLE", "nle"),
    NLEBV("亚欧专线", "nlebv"),
    NMHUAHE("华赫物流", "nmhuahe"),
    PARCELCHINA("诚一物流", "parcelchina"),
    PCWL56("普畅物流", "pcwl56"),
    PHLPOST("菲律宾（Philippine Postal）", "phlpost"),
    PINXINKUAIDI("品信快递", "pinxinkuaidi"),
    POLARISEXPRESS("北极星快运", "polarisexpress"),
    PZHJST("急顺通", "pzhjst"),
    QUANCHUAN56("全川摩运", "quanchuan56"),
    QUANJITONG("全际通", "quanjitong"),
    R2SLOGISTICS("R2S Logistics", "r2slogistics"),
    REDEXPRESS("Red Express", "redexpress"),
    ROMANIAN("罗马尼亚（Posta Romanian）", "romanian"),
    RPX("rpx", "rpx"),
    RWANDA("卢旺达(Rwanda i-posita)", "rwanda"),
    SANSTAR("盛德国际墨西哥物流", "sanstar"),
    SCCOD("丰程物流", "sccod"),
    SHANGHAIWUJIANGMMB("上海无疆for买卖宝", "shanghaiwujiangmmb"),
    SHANXIJIANHUA("山西建华", "shanxijianhua"),
    SHENGTONGSCM("盛通快递", "shengtongscm"),
    SHUNBANG("顺邦国际物流", "shunbang"),
    SICEPAT("SiCepat Ekspres", "sicepat"),
    SMSAEXPRESS("SMSA Express", "smsaexpress"),
    SPEEDA("行必达", "speeda"),
    STARYVR("星运快递", "staryvr"),
    STWLES("盛泰物流", "stwles"),
    SUFENGKUAIDI("速风快递", "sufengkuaidi"),
    SUPEROZ("速配欧翼", "superoz"),
    SUTONGHONGDA("速通鸿达", "sutonghongda"),
    SWISHIP("Amazon FBA Swiship", "swiship"),
    TANZANIA("坦桑尼亚(Tanzania Posts)", "tanzania"),
    TLKY("天联快运", "tlky"),
    TOLLPRIORITY("Toll Priority(Toll Online)", "tollpriority"),
    TOPSPEEDEX("中运全速", "topspeedex"),
    TURTLE("海龟国际快递", "turtle"),
    UNIEXPRESS("Uni Express", "uniexpress"),
    UPARCEL("UParcel", "uparcel"),
    UPSMAILINNO("UPS Mail Innovations", "upsmailinno"),
    USPSCN("USPSCN", "uspscn"),
    UZBEKISTAN("乌兹别克斯坦(Post of Uzbekistan)", "uzbekistan"),
    VIETNAM("越南小包(Vietnam Posts)", "vietnam"),
    VPS("维普恩物流", "vps"),
    WDM("万达美", "wdm"),
    WELOGISTICS("世航通运", "welogistics"),
    WOTU("渥途国际速运", "wotu"),
    XIANGLONGYUNTONG("祥龙运通物流", "xianglongyuntong"),
    XIPOST("西邮寄", "xipost"),
    XPERTDELIVERY("Xpert Delivery", "xpertdelivery"),
    XPRESSBEES("XpressBees", "xpressbees"),
    YEMEN("也门(Yemen Post)", "yemen"),
    YIBANGWULIU("一邦速递", "yibangwuliu"),
    YILINGSUYUN("亿领速运", "yilingsuyun"),
    YINGCHAO("英超物流", "yingchao"),
    YSEXPRESS("鼹鼠快送", "ysexpress"),
    YSTSD("永世通物流", "ystsd"),
    YUANHHK("远航国际快运", "yuanhhk"),
    YYEXP("西安运逸快递", "yyexp"),
    ZHPEX("众派速递", "zhpex"),
    ZHUDIANKUAIYUN("逐电快运", "zhudiankuaiyun"),
    ZJCY56("创运物流", "zjcy56"),
    ABXEXPRESS_MY("ABX Express", "abxexpress_my"),
    AGILITY("Agility Logistics", "agility"),
    AHKBPS("卡邦配送", "ahkbps"),
    AJEXPRESS("捷记方舟", "ajexpress"),
    AJLOGISTICS("澳捷物流", "ajlogistics"),
    ALBANIA("阿尔巴尼亚(Posta shqipatre)", "albania"),
    ALLIEDEXPRESS("ALLIED", "alliedexpress"),
    AMAZON_FBA_SWISHIP("Swiship UK", "amazon_fba_swiship"),
    ANJIATONGCHENG("安家同城快运", "anjiatongcheng"),
    ANJIEXIN56("安捷信物流", "anjiexin56"),
    ANJUN_LOGISTICS("Anjun Logistics", "anjun_logistics"),
    ANTERAJA("Anteraja", "anteraja"),
    APC("APC Postal Logistics", "apc"),
    APLUS100("美国汉邦快递", "aplus100"),
    ARC("ARC", "arc"),
    ARUBA("阿鲁巴[荷兰]（Post Aruba）", "aruba"),
    ASHSH("上海生生物流", "ashsh"),
    AUSEXPRESS("澳世速递", "ausexpress"),
    BAHRAIN("巴林(Bahrain Post)", "bahrain"),
    BARBADOS("巴巴多斯(Barbados Post)", "barbados"),
    BAZIRIM("皮牙子快递", "bazirim"),
    BCWELT("BCWELT", "bcwelt"),
    BDCGCC("BDC快递", "bdcgcc"),
    BEEEXPRESS("BEE express", "beeexpress"),
    BEIOU("beiou express", "beiou"),
    BELIZE("伯利兹(Belize Postal)", "belize"),
    BENIN("贝宁", "benin"),
    BENNIAO("笨鸟国际", "benniao"),
    BETTERLIFE("東邮寄", "betterlife"),
    BJXSRD("鑫锐达", "bjxsrd"),
    BLUEDART("BlueDart", "bluedart"),
    BMWLGJ("白马物流", "bmwlgj"),
    BOHEI("波黑(JP BH Posta)", "bohei"),
    BOLIVIA("玻利维亚", "bolivia"),
    BORDERGURU("BorderGuru", "borderguru"),
    BOSIND("堡昕德速递", "bosind"),
    BOSTA("Bosta", "bosta"),
    BOTSPOST("博茨瓦纳", "botspost"),
    BQCWL("百千诚物流", "bqcwl"),
    BRIDGEEXPRESS("Bridge Express", "bridgeexpress"),
    BRUNEI("文莱(Brunei Postal)", "brunei"),
    BULGARIAN("保加利亚（Bulgarian Posts）", "bulgarian"),
    BUYLOGIC("Buylogic", "buylogic"),
    CALEDONIA("新喀里多尼亚[法国](New Caledonia)", "caledonia"),
    CAMEKONG("到了港", "camekong"),
    CAMPBELLSEXPRESS("Campbell’s Express", "campbellsexpress"),
    CANPAR("Canpar", "canpar"),
    CBL("CBL Logistica", "cbl"),
    CBL_LOGISTICA("CBL Logistics", "cbl_logistica"),
    CBO56("钏博物流", "cbo56"),
    CEVALOGISTICS("CEVA Logistic", "cevalogistics"),
    CHENGDA("成达国际速递", "chengda"),
    CHENGNING("城宁供应链", "chengning"),
    CHILE("智利(Correos Chile)", "chile"),
    CHINAQINGGUAN("荣通国际", "chinaqingguan"),
    CHINASQK("SQK国际速递", "chinasqk"),
    CHINATZX("同舟行物流", "chinatzx"),
    CHNEXP("中翼国际物流", "chnexp"),
    CHRONOPOSTPORT("Chronopost Portugal", "chronopostport"),
    CHUNFAI("中国香港骏辉物流", "chunfai"),
    CITYLINK("City-Link", "citylink"),
    CITYSPRINT("citysprint", "citysprint"),
    CLOUDLOGISTICS365("群航国际物流", "cloudlogistics365"),
    CNAIR("CNAIR", "cnair"),
    CNEULOGISTICS("中欧物流", "cneulogistics"),
    COLLECTPLUS("Collect+", "collectplus"),
    COMEXPRESS("邦通国际", "comexpress"),
    CORPORATECOURIERS("Corporate couriers logistics", "corporatecouriers"),
    CORREIOS("莫桑比克（Correios de Moçambique）", "correios"),
    CORREO("乌拉圭（Correo Uruguayo）", "correo"),
    CORREOARGENTINO("阿根廷(Correo Argentina)", "correoargentino"),
    CORREOSEXPRESS("Correos Express", "correosexpress"),
    COURIERPOST("CourierPost", "courierpost"),
    COURIERSPLEASE("Couriers Please", "couriersplease"),
    CRHMD("晨睿货满多", "crhmd"),
    CSXSS("新时速物流", "csxss"),
    CZWLYN("云南诚中物流", "czwlyn"),
    DACHSER("DACHSER", "dachser"),
    DASU("达速物流", "dasu"),
    DCS("DCS", "dcs"),
    DELHIVERY("Delhivery", "delhivery"),
    DELIVERYSTATIONS("Delivery Station", "deliverystations"),
    DEPLOYEG("Deploy", "deployeg"),
    DESWORKS("澳行快递", "desworks"),
    DHLPOLAND("DHL-波兰（DHL Poland）", "dhlpoland"),
    DINDON("叮咚澳洲转运", "dindon"),
    DIRECTLINK("Direct Link", "directlink"),
    DISIFANGAU("递四方澳洲", "disifangau"),
    DJIBOUTI("吉布提", "djibouti"),
    DONGHANWL("东瀚物流", "donghanwl"),
    DONGHONG("东红物流", "donghong"),
    DOTZOT("Dotzot", "dotzot"),
    DPD_IRELAND("DPD Ireland", "dpd_ireland"),
    DPE_EXPRESS("DPE Express", "dpe_express"),
    DRAGONFE("DF物流", "dragonfe"),
    DREEVO("dreevo", "dreevo"),
    DRIVERFASTGO("老司机国际快递", "driverfastgo"),
    DTD("DTD", "dtd"),
    DTDCINDIA("DTDC India", "dtdcindia"),
    DUSHISC("渡石医药", "dushisc"),
    DYEXPRESS("大亿快递", "dyexpress"),
    ECALLTURN("E跨通", "ecallturn"),
    ECFIRSTCLASS("EC-Firstclass", "ecfirstclass"),
    ECHO("Echo", "echo"),
    ECMSGLOBAL("ECMS Express", "ecmsglobal"),
    ECOMEXPRESS("Ecom Express", "ecomexpress"),
    ECOTRANSITE("东西E全运", "ecotransite"),
    ECUADOR("厄瓜多尔(Correos del Ecuador)", "ecuador"),
    EGYEXPRESS("EGY Express Logistics", "egyexpress"),
    EGYPT("埃及（Egypt Post）", "egypt"),
    EGYPTEXPRESS("Egypt Express", "egyptexpress"),
    EKART("Ekart", "ekart"),
    ELTA("希腊包裹（ELTA Hellenic Post）", "elta"),
    EMIRATES("阿联酋(Emirates Post)", "emirates"),
    EMIRATESEN("阿联酋(Emirates Post)", "emiratesen"),
    EMONITORING("波兰小包(Poczta Polska)", "emonitoring"),
    EQUICK_CN("Equick China", "equick_cn"),
    ERIPOSTAL("厄立特里亚", "eripostal"),
    ESTAFETA("Estafeta", "estafeta"),
    ESTES("Estes", "estes"),
    ETHIOPIA("埃塞俄比亚(Ethiopian postal)", "ethiopia"),
    ETHIOPIAN("埃塞俄比亚(Ethiopian Post)", "ethiopian"),
    ETONG("E通速递", "etong"),
    EUCNRAIL("中欧国际物流", "eucnrail"),
    EUCPOST("德国 EUC POST", "eucpost"),
    EUEXPRESS("EU-EXPRESS", "euexpress"),
    EUGUOJI("易邮国际", "euguoji"),
    EUROPE8("败欧洲", "europe8"),
    EUROPEANECOM("europeanecom", "europeanecom"),
    EUSACN("优莎速运", "eusacn"),
    EVERWELLMARINE("长顺海运", "everwellmarine"),
    EXCOCOTREE("可可树美中速运", "excocotree"),
    EXPEDITORS("Expeditors", "expeditors"),
    EXPLORER56("探路速运", "explorer56"),
    EXPRESSPLUS("澳洲新干线快递", "expressplus"),
    EZHUANYUAN("易转运", "ezhuanyuan"),
    FANYUKUAIDI("凡宇快递", "fanyukuaidi"),
    FARLOGISTIS("泛远国际物流", "farlogistis"),
    FASTWAY_NZ("Fastway New Zealand", "fastway_nz"),
    FASTWAY_ZA("Fastway South Africa", "fastway_za"),
    FDS("FDS", "fds"),
    FEDEXUK("FedEx-英国件（FedEx UK)", "fedexuk"),
    FEDEXUKCN("FedEx-英国件", "fedexukcn"),
    FENGYEE("丰羿", "fengyee"),
    FIJI("斐济(Fiji Post)", "fiji"),
    FIRSTLOGISTICS("First Logistics", "firstlogistics"),
    FLEXTOCK("Flextock", "flextock"),
    FLOWERKD("花瓣转运", "flowerkd"),
    FODEL("FODEL", "fodel"),
    FOURPXUS("四方格", "fourpxus"),
    FREAKYQUICK("FQ狂派速递", "freakyquick"),
    FTLEXPRESS("法翔速运", "ftlexpress"),
    GATICN("Gati-中文", "gaticn"),
    GATIKWE("Gati-KWE", "gatikwe"),
    GDRZ58("容智快运", "gdrz58"),
    GEORGIANPOST("格鲁吉亚(Georgian Pos）", "georgianpost"),
    GEXPRESS("G EXpress", "gexpress"),
    GHANAPOST("加纳", "ghanapost"),
    GHL("环创物流", "ghl"),
    GIZTIX("GIZTIX", "giztix"),
    GJWL("冠捷物流", "gjwl"),
    GLOBALTRACKTRACE("globaltracktrace", "globaltracktrace"),
    GLSITALY("GLSItaly", "glsitaly"),
    GOGOX("GOGOX", "gogox"),
    GOJAVAS("gojavas", "gojavas"),
    GRAB("Grab", "grab"),
    GREENLAND("格陵兰[丹麦]（TELE Greenland A/S）", "greenland"),
    GSCQ365("哥士传奇速递", "gscq365"),
    GSLEXPRESS("德尚国际速递", "gslexpress"),
    GUANGDONGYONGBANG("永邦快递", "guangdongyongbang"),
    GUANTING("冠庭国际物流", "guanting"),
    GUERNSEY("根西岛", "guernsey"),
    GUOSHUNDA("国顺达物流", "guoshunda"),
    GUOSONG("国送快运", "guosong"),
    GUYANA("圭亚那", "guyana"),
    GVPEXPRESS("宏观国际快递", "gvpexpress"),
    HAIHONGWANGSONG("海红网送", "haihongwangsong"),
    HAIMENGSUDI("海盟速递", "haimengsudi"),
    HAIXINGQIAO("海星桥快递", "haixingqiao"),
    HAIZHONGZHUANYUN("海中转运", "haizhongzhuanyun"),
    HANFENGJL("翰丰快递", "hanfengjl"),
    HANGYU("航宇快递", "hangyu"),
    HANXIN("汉信快递", "hanxin"),
    HAYPOST("亚美尼亚(Haypost-Armenian Postal)", "haypost"),
    HERMES_DE("Hermes Germany", "hermes_de"),
    HERMESWORLD("Hermesworld", "hermesworld"),
    HHAIR56("华瀚快递", "hhair56"),
    HIGHWAY("Highway", "highway"),
    HJS("猴急送", "hjs"),
    HKEEX("飞豹速递", "hkeex"),
    HLPGYL("共联配", "hlpgyl"),
    HNSSD56("顺时达物流", "hnssd56"),
    HNZQWL("中强物流", "hnzqwl"),
    HOLISOLLOGISTICS("Holisol", "holisollogistics"),
    HONDURAS("洪都拉斯", "honduras"),
    HONGJIE("宏捷国际物流", "hongjie"),
    HQTD("环球通达", "hqtd"),
    HRBSYDRD("速远同城快递", "hrbsydrd"),
    HRBZYKD("卓烨快递", "hrbzykd"),
    HRE("高铁速递", "hre"),
    HSDEXPRESS("寰世达国际物流", "hsdexpress"),
    HSGTSD("海硕高铁速递", "hsgtsd"),
    HT22("海淘物流", "ht22"),
    HUAQIKUAIYUN("华企快运", "huaqikuaiyun"),
    HUAXIAHUOYUN("华夏货运", "huaxiahuoyun"),
    HUMPLINE("驼峰国际", "humpline"),
    HUNGARY("匈牙利（Magyar Posta）", "hungary"),
    HUNTEREXPRESS("hunter Express", "hunterexpress"),
    HUTONGWULIU("户通物流", "hutongwuliu"),
    HYK("上海昊宏国际货物", "hyk"),
    HZPL("华航快递", "hzpl"),
    IBCOURIER("IB Courier", "ibcourier"),
    IDEXPRESS("ID Express", "idexpress"),
    IEX("泛太优达", "iex"),
    IGCAEXPRESS("无限速递", "igcaexpress"),
    IKYI("精翼运通", "ikyi"),
    ILYANG("ILYANG", "ilyang"),
    IMILE("iMile", "imile"),
    IMLB2C("艾姆勒", "imlb2c"),
    INDOPAKET("INDOPAKET", "indopaket"),
    INPOSDOM("多米尼加（INPOSDOM – Instituto Postal Dominicano）", "inposdom"),
    INPOST_PACZKOMATY("InPost Paczkomaty", "inpost_paczkomaty"),
    INTERLINK("Interlink Express", "interlink"),
    INTERPARCEL("Interparcel", "interparcel"),
    IRAN("伊朗（Iran Post）", "iran"),
    ISRAELPOST("以色列(Israel Post)", "israelpost"),
    IXPRESS("IXPRESS", "ixpress"),
    IYOUNGSPEED("驿扬国际速运", "iyoungspeed"),
    JAMAICAPOST("牙买加（Jamaica Post）", "jamaicapost"),
    JANIO("janio", "janio"),
    JERSEYPOST("泽西岛", "jerseypost"),
    JETEXPRESSEG("Jet Express", "jetexpresseg"),
    JETEXPRESSZH("J&T Express", "jetexpresszh"),
    JETSTAREXP("捷仕", "jetstarexp"),
    JETZH("极兔国际中文", "jetzh"),
    JHX56("佳豪鑫物流", "jhx56"),
    JIAJIATONG56("佳家通货运", "jiajiatong56"),
    JIAZHOUMAO("加州猫速递", "jiazhoumao"),
    JIESHITONG("捷世通物流", "jieshitong"),
    JINDUAN("近端", "jinduan"),
    JISU("盈通物流", "jisu"),
    JIUYICN("久易快递", "jiuyicn"),
    JIXIANGYOUAU("吉祥邮（澳洲）", "jixiangyouau"),
    JMGUOXUN("国迅物流", "jmguoxun"),
    JNE("JNE", "jne"),
    JORDAN("约旦(Jordan Post)", "jordan"),
    JUMIA("Jumia", "jumia"),
    JUWU("聚物物流", "juwu"),
    JXFEX("集先锋快递", "jxfex"),
    KAHAEXPRESS("Kaha Epress", "kahaexpress"),
    KANGAROO("Kangaroo Express", "kangaroo"),
    KENYA("肯尼亚(POSTA KENYA)", "kenya"),
    KERRYTHAILAND("Kerry Express-泰国", "kerrythailand"),
    KERRYTHAILANDEN("Kerry Express-泰国", "kerrythailanden"),
    KN("Kuehne + Nagel", "kn"),
    KRTAO("淘韩国际快递", "krtao"),
    KUEHNENAGEL("Kuehne+Nagel", "kuehnenagel"),
    KURASI("KURASI", "kurasi"),
    KXDA("凯信达", "kxda"),
    KYLM360("快运联盟", "kylm360"),
    LAO("老挝(Lao Express)", "lao"),
    LAPOSTE("塞内加尔", "laposte"),
    LASY56("林安物流", "lasy56"),
    LATVIA("拉脱维亚(Latvijas Pasts)", "latvia"),
    LATVIAEN("拉脱维亚(Latvijas Pasts)", "latviaen"),
    LBBK("立白宝凯物流", "lbbk"),
    LC56("禄昌物流", "lc56"),
    LDZY168("两点之间", "ldzy168"),
    LEDAEXPRESS("乐达全球速递", "ledaexpress"),
    LEDAOWULIU("楽道物流", "ledaowuliu"),
    LEDII("乐递供应链", "ledii"),
    LEOPARD("云豹国际货运", "leopard"),
    LESOTHO("莱索托(Lesotho Post)", "lesotho"),
    LETSEML("美联快递", "letseml"),
    LEXSHIP("Laxship", "lexship"),
    LIANBANGKUAIDIEN("联邦快递-英文", "lianbangkuaidien"),
    LIONPARCEL("Lion Parcel", "lionparcel"),
    LISHI("丽狮物流", "lishi"),
    LIUJIASHEN("润禾物流", "liujiashen"),
    LOADBUGS("Loadbugs", "loadbugs"),
    LOGISTICS("華信物流WTO", "logistics"),
    LOOMISEXPRESS("Loomis Express", "loomisexpress"),
    LUBANG56("路邦物流", "lubang56"),
    LUNDAO("论道国际物流", "lundao"),
    LUXEMBOURG("卢森堡(Luxembourg Post)", "luxembourg"),
    LUXEMBOURGDE("卢森堡(Luxembourg De Post)", "luxembourgde"),
    LUXEMBOURGFR("卢森堡(Luxembourg Fr Post)", "luxembourgfr"),
    LUZUN("路尊物流", "luzun"),
    LWE("LWE", "lwe"),
    MACEDONIA("马其顿(Macedonian Post)", "macedonia"),
    MAERSK("Maersk", "maersk"),
    MAILAMERICAS("mailamericas", "mailamericas"),
    MAILONGDY("迈隆递运", "mailongdy"),
    MAINFREIGHT("Mainfreight", "mainfreight"),
    MALTA("马耳他（Malta Post）", "malta"),
    MANGGUO("芒果速递", "mangguo"),
    MAPLEEXPRESS("今枫国际快运", "mapleexpress"),
    MASCOURIERSERVICE("MAS Courier Servic", "mascourierservice"),
    MATKAHUOLTO("Matkahuolto", "matkahuolto"),
    MCHY("木春货运", "mchy"),
    MED56("金域达物流", "med56"),
    MEIBANG("美邦国际快递", "meibang"),
    MEIGUOKUAIDI("美国快递", "meiguokuaidi"),
    MEITAI("美泰物流", "meitai"),
    MERAGE("Merage", "merage"),
    MEXICO("墨西哥（Correos de Mexico）", "mexico"),
    MEXICODENDA("Mexico Senda Express", "mexicodenda"),
    MHSY("名航速运", "mhsy"),
    MILKYWAY("银河物流", "milkyway"),
    MMLOGI("猛犸速递", "mmlogi"),
    MOL("Mitsui OSK Lines", "mol"),
    MOLDOVA("摩尔多瓦(Posta Moldovei)", "moldova"),
    MONTENEGRO("黑山(Posta Crne Gore)", "montenegro"),
    MOROCCO("摩洛哥 ( Morocco Post )", "morocco"),
    MRW("MRW", "mrw"),
    MXE56("中俄速通（淼信）", "mxe56"),
    MYLERZ("mylerz", "mylerz"),
    NALEXPRESS("新亚物流", "nalexpress"),
    NANDAN("NandanCourier", "nandan"),
    NAQEL("NAQEL Express", "naqel"),
    NATIONEX("Nationex", "nationex"),
    NBHTT("早道佳", "nbhtt"),
    NEBUEX("星云速递", "nebuex"),
    NEDERLANDPOST("荷兰速递(Nederland Post)", "nederlandpost"),
    NEPALPOST("尼泊尔（Nepal Postal Services）", "nepalpost"),
    NETWORKCOURIER("Network Courier", "networkcourier"),
    NEWGISTICS("Newgistics", "newgistics"),
    NIGERIANPOST("尼日利亚(Nigerian Postal)", "nigerianpost"),
    NINJAXPRESS("ninja xpress", "ninjaxpress"),
    NIPPONEXPRESS("Nippon Express", "nipponexpress"),
    NIUZAIEXPRESS("牛仔速运", "niuzaiexpress"),
    NJHAOBO("浩博物流", "njhaobo"),
    NJHZLH("南京合纵连横物流", "njhzlh"),
    NOKCOURIER("Nok Courier", "nokcourier"),
    NORSK_GLOBAL("Norsk Global", "norsk_global"),
    NOVAPOSHTA("Nova Poshta", "novaposhta"),
    NUOYAAO("偌亚奥国际快递", "nuoyaao"),
    NXTWULIU("诺信特快递", "nxtwuliu"),
    NYK("NYK Line", "nyk"),
    OCAARGEN("OCA Argentina", "ocaargen"),
    OCPOST("OC-Post", "ocpost"),
    OCSINDIA("﻿OCS ANA Group", "ocsindia"),
    OMAN("阿曼(Oman Post)", "oman"),
    OMNI2("无限配", "omni2"),
    OMNIPARCEL("Omni Parcel", "omniparcel"),
    OMNIVA("爱沙尼亚(Eesti Post)", "omniva"),
    ONEWORLDEXPRESS("One World Express", "oneworldexpress"),
    OPEK("OPEK", "opek"),
    OPEX("OPEX", "opex"),
    OVERSEAEX("波音速递", "overseaex"),
    PACKLINK("Packlink", "packlink"),
    PAKISTAN("巴基斯坦(Pakistan Post)", "pakistan"),
    PANAMA("巴拿马", "panama"),
    PANDULOGISTICS("Pandu Logistics", "pandulogistics"),
    PARAGUAY("巴拉圭(Correo Paraguayo)", "paraguay"),
    PARCEL2GO("parcel2go", "parcel2go"),
    PARKNPARCEL("Park N Pracel", "parknparcel"),
    PAXEL("paxel", "paxel"),
    PAXELEN("paxelen", "paxelen"),
    PCAEXPRESS("PCA Express", "pcaexpress"),
    PEEX("派尔快递", "peex"),
    PEISIHUOYUNKUAIDI("配思货运", "peisihuoyunkuaidi"),
    PEIXINGWULIU("陪行物流", "peixingwuliu"),
    PENGYUANEXPRESS("鹏远国际速递", "pengyuanexpress"),
    PEPPASHIP("佩奇集运", "peppaship"),
    PERFECTSERVICE("Perfect Service", "perfectservice"),
    PERU("秘鲁(SERPOST)", "peru"),
    PESTO("Presto", "pesto"),
    PFLOGISTICS("Parcel Freight Logistics", "pflogistics"),
    PICKUPP("pickupp", "pickupp"),
    PINSUXINDA("品速心达快递", "pinsuxinda"),
    PIONEER("先锋国际快递", "pioneer"),
    PORTUGALCTTEN("葡萄牙（Portugal CTT）", "portugalctten"),
    PORTUGALSEUR("Portugal Seur", "portugalseur"),
    POSINDONESIA("POS INDONESIA", "posindonesia"),
    POSTA("坦桑尼亚（Tanzania Posts Corporation）", "posta"),
    POSTENNORGE("挪威（Posten Norge）", "postennorge"),
    POSTPNG("巴布亚新几内亚(PNG Post)", "postpng"),
    PPSUYUN("PP速运", "ppsuyun"),
    PRIMAMULTICIPTA("PT Prima Multi Cipta", "primamulticipta"),
    PTT("土耳其", "ptt"),
    QDANTS("ANTS EXPRESS", "qdants"),
    QHTCHINA("深圳市全汇通物流", "qhtchina"),
    QHXYKD("雪域快递", "qhxykd"),
    QICHEN("启辰国际速递", "qichen"),
    QPOST("卡塔尔（Qatar Post）", "qpost"),
    QUANSUTONG("全速通", "quansutong"),
    QXPRESS("Qxpress", "qxpress"),
    RAMGROUP_ZA("RAM", "ramgroup_za"),
    RAPIDOCARGOEG("Rapido Cargo Egypt", "rapidocargoeg"),
    REDUR("Redur", "redur"),
    REDUR_ES("Redur Spain", "redur_es"),
    RENSU56("仁速物流", "rensu56"),
    REPUBLIC("叙利亚(Syrian Post)", "republic"),
    RHTEXPRESS("睿和泰速运", "rhtexpress"),
    RIYUWULIU("日昱物流", "riyuwuliu"),
    RJTCSD("锐界同城速递", "rjtcsd"),
    RL_CARRIERS("RL Carriers", "rl_carriers"),
    ROYAL("皇家国际速运", "royal"),
    RRTHK("日日通国际", "rrthk"),
    RUIDIANYOUZHENGEN("瑞典（Sweden Post）", "ruidianyouzhengen"),
    RUNBAIL("润百特货", "runbail"),
    SAFEXPRESS("Safexpress", "safexpress"),
    SAGAWAEN("佐川急便-英文", "sagawaen"),
    SALVADOR("Correo El Salvador", "salvador"),
    SAMOA("萨摩亚(Samoa Post)", "samoa"),
    SANLE56("三乐物流", "sanle56"),
    SANSHENGCO("三盛快递", "sanshengco"),
    SAPEXPRESS("SAP EXPRESS", "sapexpress"),
    SCCS("SCCS", "sccs"),
    SCGLOGISTICS("SCG", "scglogistics"),
    SCIC("中加国际快递", "scic"),
    SCSUJIADA("速佳达快运", "scsujiada"),
    SENDINGLOG("森鼎国际物流", "sendinglog"),
    SENDLE("Sendle", "sendle"),
    SERBIA("塞尔维亚(PE Post of Serbia)", "serbia"),
    SEUR("International Seur", "seur"),
    SFAU("澳丰速递", "sfau"),
    SFCSERVICE("SFC Service", "sfcservice"),
    SHADOWFAX("Shadowfax", "shadowfax"),
    SHALLEXP("穗航物流", "shallexp"),
    SHANDA56("衫达快运", "shanda56"),
    SHANGTUGUOJI("尚途国际货运", "shangtuguoji"),
    SHAOKE("捎客物流", "shaoke"),
    SHBWCH("杰响物流", "shbwch"),
    SHD56("商海德物流", "shd56"),
    SHENMA("神马快递", "shenma"),
    SHIPBLU("ShipBlu", "shipblu"),
    SHIPBYACE("王牌快递", "shipbyace"),
    SHIPSOHO("苏豪快递", "shipsoho"),
    SHLEXP("SHL畅灵国际物流", "shlexp"),
    SHPOSTWISH("wish邮", "shpostwish"),
    SHREEANJANICOURIER("shreeanjanicourier", "shreeanjanicourier"),
    SIHIEXPRESS("四海捷运", "sihiexpress"),
    SIODEMKA("Siodemka", "siodemka"),
    SKYEXPRESSEG("Sky Express", "skyexpresseg"),
    SKYNET("skynet", "skynet"),
    SKYNETMALAYSIA("SkyNet Malaysia", "skynetmalaysia"),
    SKYNETWORLDWIDE("skynetworldwide", "skynetworldwide"),
    SKYPOST("荷兰Sky Post", "skypost"),
    SKYPOSTAL("Asendia HK (LATAM)", "skypostal"),
    SLOVAK("斯洛伐克(Slovenská Posta)", "slovak"),
    SLOVENIA("斯洛文尼亚(Slovenia Post)", "slovenia"),
    SLPOST("斯里兰卡(Sri Lanka Post)", "slpost"),
    SOFAST56("嗖一下同城快递", "sofast56"),
    SOLOMON("所罗门群岛", "solomon"),
    SONAPOST("布基纳法索", "sonapost"),
    SOOEASY("水趣到家", "sooeasy"),
    SPEEDAF("Speedaf", "speedaf"),
    SPEEDEGYPT("Speed Shipping Company", "speedegypt"),
    SPEEDEX("SpeedEx", "speedex"),
    SPEEDOEX("申必达", "speedoex"),
    SPOTON("Spoton", "spoton"),
    SPRINT("Sprint", "sprint"),
    STAKY("首通快运", "staky"),
    STAREX("星速递", "starex"),
    STLUCIA("圣卢西亚", "stlucia"),
    SUBAOEX("速豹", "subaoex"),
    SUCHENG("速呈宅配", "sucheng"),
    SUCHI8("广东速驰", "suchi8"),
    SUCMJ("特急便物流", "sucmj"),
    SUDAPOST("苏丹（Sudapost）", "sudapost"),
    SURPOST("苏里南", "surpost"),
    SVGPOST("圣文森特和格林纳丁斯", "svgpost"),
    SWAZILAND("斯威士兰", "swaziland"),
    SZSJTWL("世纪通物流", "szsjtwl"),
    SZZSS("中时顺物流", "szzss"),
    TALABAT("Talabat", "talabat"),
    TAOPLUS("淘布斯国际物流", "taoplus"),
    TARRIVE("通达物流", "tarrive"),
    TCIXPS("TCI XPS", "tcixps"),
    THEBLUEBHELLCOURIERS("The BlueBhell Couriers", "thebluebhellcouriers"),
    THECOURIERGUY("The Courier Guy", "thecourierguy"),
    TIANXIANG("天翔快递", "tianxiang"),
    TIKI("TiKi", "tiki"),
    TIPSA("TIPSA", "tipsa"),
    TIRUPATI("Shree Tirupati", "tirupati"),
    TMG("株式会社T.M.G", "tmg"),
    TNTPOSTCN("TNT Post", "tntpostcn"),
    TNTUK("TNT UK", "tntuk"),
    TOBKK("泰熊物流", "tobkk"),
    TOGO("多哥", "togo"),
    TONGDAXING("通达兴物流", "tongdaxing"),
    TOPSHEY("顶世国际物流", "topshey"),
    TPCINDIA("The Professional Couriers", "tpcindia"),
    TRACKPARCEL("track-parcel", "trackparcel"),
    TRANSKARGOLOGISTICS("Trans Kargo", "transkargologistics"),
    TRANSPORTER("Transporter Egypt", "transporter"),
    TURBO("Turbo", "turbo"),
    UBX("UBX", "ubx"),
    UEXIEX("欧洲UEX", "uexiex"),
    UFELIX("Ufelix", "ufelix"),
    UGANDA("乌干达(Posta Uganda)", "uganda"),
    UGOEXPRESS("邮鸽速运", "ugoexpress"),
    UHI("优海国际速递", "uhi"),
    ULUCKEX("优联吉运", "uluckex"),
    UNIONCOURIER("Union Courier SAE", "unioncourier"),
    UNITEDEXPRESS("United express courier service", "unitedexpress"),
    UPSFREIGHT("UPS Freight", "upsfreight"),
    USASUEEXPRESS("速翼快递", "usasueexpress"),
    UTAOSCM("UTAO优到", "utaoscm"),
    VANUATU("瓦努阿图(Vanuatu Post)", "vanuatu"),
    VCTRANS("越中国际物流", "vctrans"),
    VIPEXPRESS("鹰运国际速递", "vipexpress"),
    VOO("Voo", "voo"),
    WADILY("Wadily", "wadily"),
    WAHANA("Wahana", "wahana"),
    WASSALNOW("WassalNow", "wassalnow"),
    WATT("WATT", "watt"),
    WEDEL("Wedel", "wedel"),
    WEDEPOT("wedepot物流", "wedepot"),
    WEXPRESS("威速递", "wexpress"),
    WHISTL("Whistl", "whistl"),
    WLFAST("凡仕特物流", "wlfast"),
    WLN("万理诺物流", "wln"),
    WLWEX("星空国际", "wlwex"),
    WOWEXPRESS("wowexpress", "wowexpress"),
    WPOST56("渭鹏速递", "wpost56"),
    WTDEX("WTD海外通", "wtdex"),
    WTO56KJ("臣邦同城", "wto56kj"),
    WXOLYS("欧利", "wxolys"),
    XINGYUANKUAIDI("新元快递", "xingyuankuaidi"),
    XINYAN("新颜物流", "xinyan"),
    XIONGDA("雄达国际物流", "xiongda"),
    XUNXUAN("迅选物流", "xunxuan"),
    XYB2B("行云物流", "xyb2b"),
    YCGGLOBAL("YCG物流", "ycgglobal"),
    YDL56("亿德隆物流", "ydl56"),
    YIDAZHUANYUN("EMAYYA", "yidazhuanyun"),
    YIDIHUI("驿递汇速递", "yidihui"),
    YIHANGMALL("易航物流", "yihangmall"),
    YIKONN("yikonn", "yikonn"),
    YILONGEX("亿隆速运", "yilongex"),
    YINJIESUDI("银捷速递", "yinjiesudi"),
    YISHUNHANG("亿顺航", "yishunhang"),
    YISONG("宜送", "yisong"),
    YITONGDA("易通达", "yitongda"),
    YJS("益加盛快递", "yjs"),
    YKOUAN("洋口岸", "ykouan"),
    YOUYIBANG("邮驿帮高铁速运", "youyibang"),
    YUNDAEXUS("美国云达", "yundaexus"),
    YUNGUO56("蕴国物流", "yunguo56"),
    YUSEN("Yusen Logistics", "yusen"),
    ZESEXPRESS("俄顺物流", "zesexpress"),
    ZF365("珠峰速运", "zf365"),
    ZFEX56("志方物流", "zfex56"),
    ZGTUX("途兴供应链", "zgtux"),
    ZHAOJIN("招金精炼", "zhaojin"),
    ZHDWL("众辉达物流", "zhdwl"),
    ZHONGANHUOYUN("中安物流", "zhonganhuoyun"),
    ;
    
    private final String companyName;
    
    private final String code;
    
    private static final Map<String, ExpressCompanyCodeEnum> COMPANY_NAME_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ExpressCompanyCodeEnum::getCompanyName, Function.identity(), (v1, v2) -> {
        log.error("ExpressCompanyCodeEnum, companyName distinct, companyName={}", v2.getCompanyName());
        return v2;
    })));
    
    /**
     * 根据公司名称获取枚举
     * @param companyName 公司名称
     * @return 枚举
     */
    public static ExpressCompanyCodeEnum getByCompanyName(String companyName) {
        if (companyName == null) {
            return null;
        }
        return COMPANY_NAME_ENUM_MAP.get(companyName);
    }
    
    private static final Map<String, ExpressCompanyCodeEnum> CODE_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ExpressCompanyCodeEnum::getCode, Function.identity(), (v1, v2) -> {
        log.error("ExpressCompanyCodeEnum, code distinct, code={}", v2.getCode());
        return v2;
    })));
    
    /**
     * 根据公司名称获取枚举
     * @param code 公司名称
     * @return 枚举
     */
    public static ExpressCompanyCodeEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        return CODE_ENUM_MAP.get(code);
    }
    
}
