package cn.com.duiba.quanyi.center.api.remoteservice.bank.hzbank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.bank.hzbank.HzBankBillUploadRecordDto;
import cn.com.duiba.quanyi.center.api.param.bank.hzbank.HzBankBillUploadRecordSearchParam;
import java.util.List;

/**
 * 杭州银行账单上传记录表
 * @author kjj mybatis generator 
 * @date 2024-04-08
 */
@AdvancedFeignClient
public interface RemoteHzBankBillUploadRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 杭州银行账单上传记录集合
     */
    List<HzBankBillUploadRecordDto> selectPage(HzBankBillUploadRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(HzBankBillUploadRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 杭州银行账单上传记录
     */
    HzBankBillUploadRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 杭州银行账单上传记录
     * @return 执行结果
     */
    Long insert(HzBankBillUploadRecordDto dto);

    /**
     * 更新
     * @param dto 杭州银行账单上传记录
     * @return 影响行数
     */
    int update(HzBankBillUploadRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}