package cn.com.duiba.quanyi.center.api.dto.activity.common.result;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author lizhi
 * @date 2025/4/22 09:52
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityCommonUserResultDto extends ActivityCommonBaseUserResultDto {

    private static final long serialVersionUID = 3824015657716216990L;

    /**
     * 剩余领取次数
     */
    private Long surplusTakeNum;

    /**
     * 活动是否可领取详情
     */
    private ActivityCommonUserResultCanTakeDto activityCanTake;

    /**
     * 不在黑名单
     */
    private Boolean inBlackList;

    /**
     * 报名验证
     * true-验证通过，false-验证不通过，null-无需验证
     */
    private Boolean signUpVerify;

    /**
     * 报名验证不通过错误码
     */
    private String signUpVerifyErrCode;

    /**
     * 处理中的订单号，为null或空字符串说明不存在处理中订单
     */
    private String processingBizOrderNo;

    /**
     * 奖品列表
     */
    private List<ActivityCommonUserPrizeResultDto> prizeList;

}
