package cn.com.duiba.quanyi.center.api.param.task;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 定时任务记录表
 * @author mybatis generator 
 * @date 2025-06-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ScheduledTaskRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17496211769862485L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 任务主键ID,tb_scheduled_task.id
     */
    private Long taskId;

    /**
     * 任务时间
     */
    private Date taskTime;

    /**
     * 任务状态，0-未执行，1-执行中，2-执行成功，3-执行失败
     */
    private Integer taskStatus;

    /**
     * 记录信息（错误或者操作信息）
     */
    private String recordMsg;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;
}