package cn.com.duiba.quanyi.center.api.dto.goods.ext;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2025/2/13 14:49
 */
@Data
public class GoodsOrderExtDto implements Serializable {
    
    private static final long serialVersionUID = 1350662553125812728L;

    /**
     * 指定面额发券，面额
     * 说明：定面额发券场景，券面额，其他场景不需要填，单位：分。 
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponValue;

    /**
     * 指定面额发券，券门槛
     * 说明：指定面额发券批次门槛，其他场景不需要，单位：分。 
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponMinimum;

    /**
     * 微信用户openId
     */
    private String wxOpenId;

    /**
     * 微信公众号、小程序AppID
     */
    private String wxAppId;

    /**
     * 支付宝用户id，可通过支付宝授权方式获取
     */
    private String alipayUserId;

    /**
     * 支付宝openId, 映射支付宝user_id
     * 请使用open_id，后续user_id将不支持新接入使用，存量已对接的也将逐步回收。
     */
    private String alipayOpenId;

    /**
     * 支付宝登录账号，邮箱格式
     */
    private String alipayLoginId;

    /**
     * 支付宝登录账号，手机号格式
     */
    private String alipayPhoneId;

    /**
     * 抖音openId
     */
    private String douyinOpenId;

    /**
     * 充值手机号
     */
    private String phone;

    /**
     * 充值账号
     * ● 商品为油卡时有值
     */
    private String account;

    /**
     * 充值qq号
     */
    private String qqAccount;

    /**
     * 卡密类型
     */
    private Integer kmType;

    /**
     * 用户真实姓名
     * ● 商品为微信到零钱时，可选，若填值，会校验openId与该姓名是否一致
     */
    private String realName;

    /**
     * 转账金额，单位：分
     * ● 商品为微信到零钱，且为不定额时必填
     * ● 商品为微信红包时，且为不定额时必填
     * ● 商品为京东E卡时，且为不定额时必填
     * ● 商品为话费时，且为不定额时必填
     */
    private Long transferAmount;

    /**
     * 转账备注
     * ● 商品为微信到零钱时，必填
     * ● 商品为微信红包时，为活动名称，必填
     */
    private String transferRemark;

    /**
     * 商户名称
     * ● 商品为微信红包时，必填
     */
    private String redpackBusiness;

    /**
     * 红包祝福语
     * ● 商品为微信红包时，必填
     */
    private String redpackBlessings;

    /**
     * 签名
     * ● 目前只有京东会用到该字段
     */
    private String sign;

    /**
     * 验证码
     * ● 目前只有京东会用到该字段
     */
    private String code;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 是否订阅快递信息
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     */
    private Integer subExpress;

    /**
     * 姓名
     */
    private String name;

    /**
     * 收货地址 省份
     */
    private String province;

    /**
     * 收货地址 市
     */
    private String city;

    /**
     * 收货地址 区、县
     */
    private String district;

    /**
     * 收货地址 街道
     */
    private String street;

    /**
     * 收货详细地址
     */
    private String address;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 平台服务编码
     */
    private String platformCode;

    /**
     * 门店服务ID，兑吧门店必传
     * 传入门店服务ID时，可不传门店编码、平台服务编码
     */
    private Long storeSerId;

    /**
     * 车牌号
     */
    private String carNumber;

    /**
     * 有效期天数
     */
    private Integer expireDays;

    /**
     * appId
     */
    private String appId;
    
}
