package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.QyPsbcBillDetailDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.QyPsbcBillDetailSearchParam;
import java.util.List;

/**
 * 邮储账单明细用于对账
 * @author kjj mybatis generator
 * @date 2025-10-15
 */
@AdvancedFeignClient
public interface RemoteQyPsbcBillDetailService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 邮储账单明细用于对账集合
     */
    List<QyPsbcBillDetailDto> selectPage(QyPsbcBillDetailSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(QyPsbcBillDetailSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 邮储账单明细用于对账
     */
    QyPsbcBillDetailDto selectById(Long id);

    /**
     * 新增
     * @param dto 邮储账单明细用于对账
     * @return 执行结果
     */
    int insert(QyPsbcBillDetailDto dto);

    /**
     * 更新
     * @param dto 邮储账单明细用于对账
     * @return 影响行数
     */
    int update(QyPsbcBillDetailDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 分页查询未停止的批次
     * @param lastId 上次扫描到的ID
     * @param pageSize 每页查询条数
     * @return 邮储账单明细用于对账集合
     */
    List<QyPsbcBillDetailDto> selectByLastId(Long lastId, Integer pageSize);
}
