package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityStaffTimeDto;

import java.util.List;
import java.util.Set;

/**
 * 活动员工时间限制信息表
 * @author kjj mybatis generator 
 * @date 2024-04-19
 */
@AdvancedFeignClient
public interface RemoteActivityStaffTimeService {

    /**
     * 根据员工表主键查询
     * @param actStaffId 员工表主键，对应tb_activity_staff.id
     * @return 活动员工时间限制信息
     */
    List<ActivityStaffTimeDto> selectByActStaffId(Long actStaffId);

    /**
     * 根据员工表主键批量查询
     * @param actStaffIds 员工表主键，对应tb_activity_staff.id
     * @return 活动员工时间限制信息
     */
    List<ActivityStaffTimeDto> selectByActStaffIds(Set<Long> actStaffIds);
}