package cn.com.duiba.quanyi.center.api.enums.partner;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 联系人角色枚举：1-决策人，2-负责人，3-对接人
 */
@Getter
@AllArgsConstructor
public enum PartnerContactPersonRoleEnum {
    DECISION_MAKER(1, "决策人"),
    PERSON_IN_CHARGE(2, "负责人"),
    CONTACT_PERSON(3, "对接人");

    private final Integer code;
    private final String desc;

    /**
     * 通过描述获取编码
     * @param desc 角色描述
     * @return 角色编码
     */
    public static Integer getCodeByDescription(String desc) {
        for (PartnerContactPersonRoleEnum role : values()) {
            if (role.getDesc().equals(desc)) {
                return role.getCode();
            }
        }
        return null;
    }

    /**
     * 通过编码获取描述
     * @param code 角色编码
     * @return 角色描述
     */
    public static String getDescriptionByCode(Integer code) {
        for (PartnerContactPersonRoleEnum role : values()) {
            if (role.getCode().equals(code)) {
                return role.getDesc();
            }
        }
        return null;
    }
}
