package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.enums.alipay.AlipayActivityBizStatusEnum;
import cn.com.duiba.quanyi.center.api.enums.alipay.AlipayCoinsActTypeEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 支付宝立减金表
 *
 * @author kjj mybatis generator
 * @date 2023-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class AlipayCountCoinsActivityPageParam extends PageQuery {

    private static final long serialVersionUID = -6056818657968858650L;

    /**
     * 支付宝数币红包活动ID
     */
    private String alipayActId;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    private List<Long> demandGoodsIds;

    /**
     * 面额，单位分
     */
    private Long discountValue;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 支付宝数币活动名称
     */
    private String countCoinsName;

    /**
     * 模板id
     */
    private String templateId;

    /**
     * 商户号
     */
    private String mchCode;

    /**
     * 业务状态：1-待分配, 2-已分配
     * {@link AlipayActivityBizStatusEnum}
     */
    private Integer bizStatus;

    /**
     * 批次类型
     * @see AlipayCoinsActTypeEnum
     */
    private Integer alipayActType;

    /**
     * 支付宝数币活动状态
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer alipayActStatus;

    /**
     * 支付宝分配给开发者的应用ID
     */
    private String alipayAppId;

    /**
     * 筛选已绑定优惠券 1-是
     */
    private Integer selectBindCoupon;

    /**
     * 需求id
     */

    private Long demandId;

    /**
     * skuId
     */
    private Long skuId;
}
