package cn.com.duiba.quanyi.center.api.dto.contract;

import cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 合同表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ContractDto implements Serializable {

    private static final long serialVersionUID = 4839906531083624544L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合作客户主键, tb_partner.id
     */
    private Long partnerId;

    /**
     * 合同编号
     */
    private String contractCode;

    /**
     * 合同文件地址
     */
    private String contractFile;

    /**
     * 消耗类型, 1-框架，2-预算
     *
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractConsumeTypeEnum
     */
    private Integer consumeType;

    /**
     * 消耗上限
     */
    private String consumeDesc;

    /**
     * 合作开始时间
     */
    private Date startTime;

    /**
     * 合作结束时间
     */
    private Date endTime;

    /**
     * 合同运营，多个以英文逗号分隔
     */
    private String contractOperations;

    /**
     * 合作运营姓名
     */
    private String contractOperationsName;

    /**
     * 合同商务，多个以英文逗号分隔
     */
    private String contractCommerce;

    /**
     * 合同商务姓名
     */
    private String contractCommerceName;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 创建人id
     */
    private Long createOperatorId;
    /**
     * 创建人名称
     */
    private String createOperatorName;
    /**
     * 纷享销客合同号
     */
    private String salesContractNumber;

    /**
     * 业务主体
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.subject.SubjectEnum
     */
    private Long duibaSubject;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 合同ID 创建日期+编号
     */
    private String contractNo;

    /**
     * 合同类型1-权益主合同 2-权益附属合同
     *
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractTypeEnum
     */
    private Integer contractType;

    /**
     * 客户签订主体
     */
    private String partnerSubject;

    /**
     * 关联主合同 合同类型为权益附属合同时有值
     */
    private Long mainContractId;

    /**
     * 关联主合同 合同类型为权益附属合同时有值
     */
    private String mainContractCode;

    /**
     * 所属业务
     *
     * @see BelongingBusinessTypeEnum#getType()
     */
    private Integer belongingBusiness;

    /**
     * 合同附件
     */
    private String contractAttachments;

    /**
     * 合同备注
     */
    private String contractRemark;

    /**
     * 合作金额 单位分
     */
    private Long cooperationAmount;

    /**
     * 归档类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ArchiveTypeEnum
     */
    private Integer archiveType;

    /**
     * 是否需要打印 0-不需要 1-需要
     */
    private Integer needPrint;

    /**
     * 盖章类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.contract.StampTypeEnum
     */
    private String stampTypes;

    /**
     * 归档日期
     */
    private Date archiveDate;

    /**
     * 钉钉审批流状态
     * {@link cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum}
     */
    private Integer approvalStatus;

    /**
     * 合同状态
     *
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractStatusEnum
     */
    private Integer contractStatus;

    /**
     * 审批拒绝原因
     */
    private String approvalRejectReason;

    /**
     * 权益采购金额
     */
    private Long purchaseAmount;

    /**
     * 定制产品金额
     */
    private Long customizedProductAmount;

    /**
     * 标准产品金额
     */
    private Long standardProductAmount;

    /**
     * 组合产品
     */
    private String productPortfolio;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 兑吧APPID
     */
    private String duibaAppId;

    /**
     * 兑吧账号主体
     * 1.兑吧 2.兑啊 3.客吉吉 4.安徽兑吧 5.其他
     * @see cn.com.duiba.quanyi.center.api.enums.contract.DuibaAccountSubjectEnum
     */
    private Integer duibaAccountSubject;

    /**
     * 合同金额类型
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractCooperationTypeEnum
     */
    private Integer contractAmountType;

    /**
     * 是否提前开发
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer earlyDevelopment;

    /**
     * 是否有打折选择
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer discountOptions;

    /**
     * 标准合作类型
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractCooperationTypeEnum
     */
    private Integer standardCooperationType;

    /**
     * 定制合作类型
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractCooperationTypeEnum
     */
    private Integer customizedCooperationType;

    /**
     * 权益合作类型
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractCooperationTypeEnum
     */
    private Integer purchaseCooperationType;

    /**
     * 纷享销客合同code
     */
    private String fxxkContractCode;

    /**
     * 纷享销客客户code
     */
    private String fxxkPartnerCode;

    /**
     * 合同金额
     */
    private Long contractTotalAmount;

    /**
     * 签约对接人姓名
     */
    private String signContactsName;

    /**
     * 签约对接人联系方式
     */
    private String signContactsPhone;
}

