package cn.com.duiba.quanyi.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.common.UnBindRecordDto;

/**
 * 解绑记录远程服务
 * @author yangyukang
 * @date 2025-10-27 19:50
 */
@AdvancedFeignClient
public interface RemoteUnBindRecordService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 解绑记录
     */
    UnBindRecordDto selectById(Long id);

    /**
     * 根据用户ID查询列表
     * @param userId 用户ID
     * @return 解绑记录列表
     */
    List<UnBindRecordDto> selectByUserId(Long userId);

    /**
     * 根据业务类型和业务ID查询列表
     * @param unbindBizType 解绑类型
     * @param unbindBizId 解绑业务ID
     * @return 解绑记录列表
     */
    List<UnBindRecordDto> selectByBizTypeAndBizId(Integer unbindBizType, Long unbindBizId);

    /**
     * 根据用户ID和解绑类型查询列表
     * @param userId 用户ID
     * @param unbindBizType 解绑类型
     * @return 解绑记录列表
     */
    List<UnBindRecordDto> selectByUserIdAndBizType(Long userId, Integer unbindBizType);

    /**
     * 新增解绑记录
     * @param dto 解绑记录
     * @return 解绑记录id
     */
    Long insert(UnBindRecordDto dto);

    /**
     * 更新解绑记录
     * @param dto 解绑记录
     * @return 执行结果
     */
    int update(UnBindRecordDto dto);
}
