package cn.com.duiba.quanyi.center.api.enums.api;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 批量生成链接任务状态枚举
 *
 * @author lizhi
 * @date 2023/12/21 16:06
 */
@Getter
@AllArgsConstructor
public enum BatchGenerateUrlTaskStatusEnum {

    PROCESS(1,"处理中"),

    FINISH(2,"已完成"),

    FAIL(3,"失败"),
    ;

    private final Integer status;

    private final String desc;

    private static final Map<Integer, BatchGenerateUrlTaskStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BatchGenerateUrlTaskStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static BatchGenerateUrlTaskStatusEnum getByStatus(Integer status) {
        //默认返回处理中
        if (status == null) {
            return PROCESS;
        }
        return ENUM_MAP.get(status);
    }

}
