package cn.com.duiba.quanyi.center.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/3/5 13:54
 */
@Data
public class BaseResultDto<T> implements Serializable {
    
    private static final long serialVersionUID = 6209920229893069090L;

    /**
     * 是否提交成功
     */
    private Boolean success;

    /**
     * 错误码
     */
    private String errCode;

    /**
     * 错误描述
     */
    private String errMsg;

    /**
     * 数据
     */
    private T data;
    
    public static <T> BaseResultDto<T> success(T data) {
        BaseResultDto<T> dto = new BaseResultDto<>();
        dto.setSuccess(true);
        dto.setData(data);
        return dto;
    }
    
    public static <T> BaseResultDto<T> fail(String errCode, String errMsg) {
        BaseResultDto<T> dto = new BaseResultDto<>();
        dto.setSuccess(false);
        dto.setErrCode(errCode);
        dto.setErrMsg(errMsg);
        return dto;
    }
}
