package cn.com.duiba.quanyi.center.api.enums.template;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 模板字段业务查询类型枚举
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@Getter
@AllArgsConstructor
public enum TemplateFieldBizTypeEnum {

    NONE(0, "无查询", false),
    SUPPLIER_ID(1, "供货id", true),
    ACTIVITY_ID(2, "活动id", true),
    ;

    /**
     * 业务类型值
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 是否需要查询
     */
    private final boolean needQuery;

    /**
     * 根据type值获取对应的枚举
     *
     * @param type 类型值
     * @return 对应的枚举，未找到返回null
     */
    public static TemplateFieldBizTypeEnum getBizTypeEnum(Integer type) {
        if (type == null) {
            return null;
        }
        for (TemplateFieldBizTypeEnum bizType : TemplateFieldBizTypeEnum.values()) {
            if (bizType.getType().equals(type)) {
                return bizType;
            }
        }
        return null;
    }
} 