package cn.com.duiba.quanyi.center.api.remoteservice.settlement.receive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.receive.ReceivedPaymentDto;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedAssociateDepositParam;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedDisassociateDepositParam;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedPaymentAssociationParam;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedPaymentDisassociationParam;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedPaymentSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 回款
 * @author kjj mybatis generator
 * @date 2024-12-11
 */
@AdvancedFeignClient
public interface RemoteReceivedPaymentService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 回款集合
     */
    List<ReceivedPaymentDto> selectPage(ReceivedPaymentSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ReceivedPaymentSearchParam param);

    /**
     * 根据主键查询
     * @param ids 主键
     * @return 回款
     */
    List<ReceivedPaymentDto> selectByIds(Set<Long> ids);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 回款
     */
    ReceivedPaymentDto selectById(Long id);

    /**
     * 批量新增
     * @param list 回款
     * @return 回填ID后的回款信息
     */
    List<ReceivedPaymentDto> batchInsert(List<ReceivedPaymentDto> list);

    /**
     * 修改商务
     * @param id 主键
     * @param commerceId 商务ssoId
     * @param commerceName 商务名称
     * @return 执行结果
     */
    int updateCommerce(Long id, Long commerceId, String commerceName);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量关联
     * @param param 关联参数
     * @return 记录ID
     */
    BaseResultDto<Long> association(ReceivedPaymentAssociationParam param);

    /**
     * 批量取消关联
     * @param param 取消关联参数
     * @return 记录ID
     */
    BaseResultDto<Long> disassociation(ReceivedPaymentDisassociationParam param);

    /**
     * 获取审批流类型
     * @param recordType 记录类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedRecordTypeEnum
     * @param receivedStatus 回款状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedStatusEnum
     * @return 审批流类型，为null时不发起审批
     */
    Integer getWorkflowType(Integer recordType, Integer receivedStatus);

    /**
     * 根据回款金额以及回款主体查询回款集合
     * @param amountList 回款金额集合
     * @param subjectList 回款主体集合
     * @return 待关联的回款集合
     */
    List<ReceivedPaymentDto> selectByAmountAndSubject(List<Long> amountList, List<String> subjectList);

    /**
     * 查询全量待关联的回款集合（刷历史数据专用）
     * @return 待关联的回款集合
     */
    List<ReceivedPaymentDto> selectToBeAssociatedPayment();

    /**
     * 根据回款主体筛选所有待关联数据
     * @param subjects
     * @return
     */
    List<ReceivedPaymentDto> selectToBeAssociatedPaymentByPaymentSubject(Set<String> subjects);

    /**
     * 根据回款单id查询
     * @param receivedNos 主键
     * @return 汇款单集合
     */
    List<ReceivedPaymentDto> selectByReceivedNos(List<String> receivedNos);

    /**
     * 根据taskId查询
     * @param taskId 导入的任务ID
     * @return 回款集合
     */
    List<ReceivedPaymentDto> selectByTaskId(Long taskId);

    /**
     * 根据taskId集合批量查询
     * @param taskIds 导入的任务ID集合
     * @return 回款集合
     */
    List<ReceivedPaymentDto> selectByTaskIds(Set<Long> taskIds);

    /**
     * 根据taskId查询（带数量限制）
     * @param taskId 导入的任务ID
     * @param pageSize 查询数量限制
     * @return 回款集合
     */
    List<ReceivedPaymentDto> selectByTaskIdLimit(Long taskId, Integer pageSize);

    /**
     * 根据taskId集合批量查询（带数量限制）
     * @param taskIds 导入的任务ID集合
     * @param pageSize 查询数量限制
     * @return 回款集合
     */
    List<ReceivedPaymentDto> selectByTaskIdsLimit(Set<Long> taskIds, Integer pageSize);

    /**
     * 根据id集合批量删除（逻辑删除）
     * @param ids 主键集合
     * @return 影响行数
     */
    int batchDelete(Set<Long> ids);

    /**
     * 根据任务id查询被关联的数量
     * @param taskId 任务id
     * @return 数量
     */
    long selectAssociatedNums(Long taskId);

    /**
     * 更新所属业务
     * @param id 主键id
     * @param belongingBusiness 所属业务 {@link cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum}
     * @return 更新结果
     */
    int updateBelongingBusinessById(Long id, Integer belongingBusiness);

    /**
     * 关联保证金
     * @param param 参数
     * @return 记录id
     */
    Long associateDeposit(ReceivedAssociateDepositParam param);

    /**
     * 取消关联保证金
     * @param param 参数
     * @return 记录id
     */
    Long disassociateDeposit(ReceivedDisassociateDepositParam param);
}
