package cn.com.duiba.quanyi.center.api.dto.activity.common.result;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2025/4/22 09:52
 */
@Data
public class ActivityCommonBaseUserResultDto implements Serializable {

    private static final long serialVersionUID = 3824015657716216990L;

    /**
     * 活动是否可访问
     */
    private Boolean canAccess;

    /**
     * 活动不可访问错误码
     */
    private String accessErrCode;

    /**
     * 用户校验通过
     */
    private Boolean userCheckPass;

    /**
     * 用户校验不通过原因
     */
    private String userCheckErrCode;

    /**
     * 活动是否在领取时间内
     */
    private Boolean inTakeTime;

    /**
     * 活动不在领取时间内错误码
     */
    private String takeTimeErrCode;

    /**
     * 当前是否可以报名
     * 当前不在报名周期/活动无参与权限/活动不可访问
     */
    private Boolean canSignedUp;

    /**
     * 不能报名错误码
     */
    private String signUpErrCode;

    /**
     * 本期是否已报名
     */
    private Boolean signedUp;

    /**
     * 报名ID(不需要校验时是本期已报名ID，需要验证时，是符合周期的报名ID)
     */
    private Long signUpId;

    /**
     * 展示的用户ID，活动开启展示用户ID时有值
     */
    private String showUserId;

    /**
     * 无法展示用户ID的原因
     */
    private String showUserIdErrCode;

}
