package cn.com.duiba.quanyi.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 建行数币红包
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class CcbCountCoinsActivityDto implements Serializable {

    private static final long serialVersionUID = 876210091503353658L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 建行数币红包活动id
     */
    private String ccbActId;

    /**
     * 建行数币红包活动秘钥
     */
    private String ccbActKey;

    /**
     * 面额
     */
    private Long amount;

    /**
     * 满减门槛
     */
    private Long discountReductionThreshold;

    /**
     * 活动总预算值，以分为单位
     */
    private Long totalBudget;

    /**
     * 发放开始时间
     */
    private Date startTime;

    /**
     * 发放结束时间
     */
    private Date endTime;

    /**
     * 活动规则
     */
    private String activityRule;


    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 活动状态 0停用 1启用
     */
    private Integer activityStatus;

    /**
     * 项目ID
     */
    private Long projectId;
}
