package cn.com.duiba.quanyi.center.api.dto.payment;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 供应商预付款抵扣
 * @author xuzhigang 
 * @date 2025-09-17 16:20
 */
@Data
public class SupplierPrepaymentDeductionDto implements Serializable {
     
    private static final long serialVersionUID = 17345671234567895L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 预付款ID
     */
    private Long prepaymentId;

    /**
     * 供应商付款ID
     */
    private Long supplierPaymentId;

    /**
     * 供应商付款编号
     */
    private String supplierPaymentNo;

    /**
     * 抵扣金额
     */
    private Long deductionAmount;

    /**
     * 抵扣状态 1-审批中 2-审批成功 3-审批失败
     */
    private Integer deductionStatus;
}
