package cn.com.duiba.quanyi.center.api.dto.task;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 定时任务记录表
 * @author mybatis generator 
 * @date 2025-06-11
 */
@Data
public class ScheduledTaskRecordDto implements Serializable {
     
    private static final long serialVersionUID = 1749621176986940L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 任务主键ID,tb_scheduled_task.id
     */
    private Long taskId;

    /**
     * 任务时间
     */
    private Date taskTime;

    /**
     * 任务状态，0-未执行，1-执行中，2-执行成功，3-执行失败
     */
    private Integer taskStatus;

    /**
     * 记录信息（错误或者操作信息）
     */
    private String recordMsg;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;
}