package cn.com.duiba.quanyi.center.api.dto.invoice;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 发票回款超期排行榜
 * @author xuzhigang
 * @date 2025/1/21
 */
@Data
public class InvoiceReceivedOverdueRankDto implements Serializable {

    private static final long serialVersionUID = 17364024890963778L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 商务负责人ID
     */
    private Long commerceManagerId;

    /**
     * 商务负责人姓名
     */
    private String commerceManagerName;

    /**
     * 运营负责人ID
     */
    private Long operationsManagerId;

    /**
     * 运营负责人姓名
     */
    private String operationsManagerName;

    /**
     * 超期发票数
     */
    private Integer overdueInvoiceCount;

    /**
     * 超期发票金额（分）
     */
    private Long overdueInvoiceAmount;

    /**
     * 严重超期发票数
     */
    private Integer seriousOverdueInvoiceCount;

    /**
     * 严重超期发票金额（分）
     */
    private Long seriousOverdueInvoiceAmount;

    /**
     * 排名位置
     */
    private Integer rankPosition;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 客户名称
     */
    private String partnerName;
}
