package cn.com.duiba.quanyi.center.api.param.warn;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * 钉钉工作通知告警记录表
 * @author mybatis generator
 * @date 2025-06-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DingDingWarnRecordSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17490180483412419L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 告警类型1：活动库存不足，2：批次库存不足，3.批次即将到期，4：商户余额不足，5：批次创建失败
     * @see cn.com.duiba.quanyi.center.api.enums.warn.DingDingWarnTypeEnum
     */
    private Integer warnType;

    /**
     * 处理状态 0=待处理，1=已处理
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer processStatus;

    /**
     * 告警通知人
     */
    private Long warnOperatorId;
}
