package cn.com.duiba.quanyi.center.api.remoteservice.qy.alipay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.alipay.AlipayCouponConfigBudgetChangRecordDto;
import cn.com.duiba.quanyi.center.api.param.qy.alipay.AlipayCouponConfigBudgetChangRecordSearchParam;

import java.util.List;

/**
 * 支付宝立减金配置预算变更记录表
 * @author kjj mybatis generator 
 * @date 2024-08-22
 */
@AdvancedFeignClient
public interface RemoteAlipayCouponConfigBudgetChangRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 支付宝立减金配置预算变更记录集合
     */
    List<AlipayCouponConfigBudgetChangRecordDto> selectPage(AlipayCouponConfigBudgetChangRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AlipayCouponConfigBudgetChangRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝立减金配置预算变更记录
     */
    AlipayCouponConfigBudgetChangRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝立减金配置预算变更记录
     * @return 执行结果
     */
    int insert(AlipayCouponConfigBudgetChangRecordDto dto);

    /**
     * 更新
     * @param dto 支付宝立减金配置预算变更记录
     * @return 影响行数
     */
    int update(AlipayCouponConfigBudgetChangRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}