package cn.com.duiba.quanyi.center.api.remoteservice.qy.autogrant;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.autogrant.AutoGrantGoodsOrderTaskResultDto;

/**
 * 自动塞券任务表
 *
 * @author kjj mybatis generator
 * @date 2025-01-22
 */
@AdvancedFeignClient
public interface RemoteAutoGrantGoodsOrderTaskService {

    /**
     * 生成发放任务记录（邮储定制专用）
     *
     * @param mainOrderNum main order num
     * @return {@link Boolean }
     */
    Boolean psbcGenerateTask(String mainOrderNum);

    /**
     * 停止塞券（根据批量订单号删除未发放的塞券任务）
     *
     * @param batchOrderNo 批量订单号
     * @return 影响的行数
     * @author yangyukang
     * @date 2025-01-23 14:30
     */
    Integer stopCouponsGrant(String batchOrderNo);

    /**
     * 根据批量订单号查询自动塞券任务
     *
     * @param batchOrderNo 批量订单号
     * @return 自动塞券任务列表
     * @author yangyukang
     * @date 2025-01-23 15:00
     */
    List<AutoGrantGoodsOrderTaskResultDto> selectByBatchOrderNo(String batchOrderNo);

    /**
     * 根据批量订单号列表查询自动塞券任务（返回Map结构）
     *
     * @param batchOrderNoList 批量订单号列表
     * @return Map结构，key为批量订单号，value为对应的任务列表
     * @author yangyukang
     * @date 2025-01-23 15:00
     */
    Map<String, List<AutoGrantGoodsOrderTaskResultDto>> selectByBatchOrderNoList(List<String> batchOrderNoList);
}