package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 业务组类型 1-权益 2-数字营销
 * @author cxw
 * @date 2025/06/25
 */
@Getter
@AllArgsConstructor
public enum BusinessGroupTypeEnum {
    RIGHTS(1, "权益"),
    DIGITAL(2, "数字营销"),
    ;

    private final Integer type;
    private final String desc;

    private static final Map<String, BusinessGroupTypeEnum> DESC_ENUM_MAP =
            Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BusinessGroupTypeEnum::getDesc, Function.identity(), (v1, v2) -> v2)));

    public static BusinessGroupTypeEnum getEnum(Integer type) {
        for (BusinessGroupTypeEnum enumItem : BusinessGroupTypeEnum.values()) {
            if (enumItem.getType().equals(type)) {
                return enumItem;
            }
        }
        return null;
    }

    public static String getDescByType(Integer type) {
        BusinessGroupTypeEnum enumItem = getEnum(type);
        if (enumItem != null) {
            return enumItem.getDesc();
        }
        return null;
    }
}
