package cn.com.duiba.quanyi.center.api.enums.abc;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author nongfu
 * @Date 2025/6/18 15:45
 */
@AllArgsConstructor
@Getter
public enum AbcEquityTypeEnum {

    ALIPAY_EQUITY("AlipayEquity","DBALIPAY","支付宝权益"),
    //抖音
    DOU_YIN_EQUITY("DYEquity","DBDY","抖音权益")
    ;
    private final String equityType;
    private final String batchAppID;
    private final String desc;

    public static AbcEquityTypeEnum getAbcEquityType(String equityType) {
        for (AbcEquityTypeEnum abcEquityTypeEnum : values()) {
            if (Objects.equals(abcEquityTypeEnum.getEquityType(), equityType)) {
                return abcEquityTypeEnum;
            }
        }
        return null;
    }
}
