package cn.com.duiba.quanyi.center.api.remoteservice.dayan;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandDayanDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandDayanPageQueryParam;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPageQueryParam;

import java.util.List;

/**
 * 大雁项目服务-对应聚宝盆需求
 */
@AdvancedFeignClient
public interface RemoteDayanProjectService {

    /**
     * 新增或修改
     * @param demandDayanDto 大雁项目 -> 对应聚宝盆需求
     * @return 聚宝盆需求ID
     */
    Long saveOrUpdate(DemandDayanDto demandDayanDto) throws BizException;

    /**
     * 查询已开票金额
     * @param dayanProjectId 大雁项目id
     * @return 开票金额（分）
     */
    Long queryApplyAmount(Long dayanProjectId);
}
