package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.AlipayCountCoinsWriteOffDataStatisticDto;

import java.util.List;

/**
 * 支付宝海豚核销数据统计表
 * @author kjj mybatis generator
 * @date 2025-06-17
 */
@AdvancedFeignClient
public interface RemoteAlipayCountCoinsWriteOffDataStatisticService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝海豚核销数据统计
     */
    AlipayCountCoinsWriteOffDataStatisticDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝海豚核销数据统计
     * @return 执行结果
     */
    int insert(AlipayCountCoinsWriteOffDataStatisticDto dto);

    /**
     * 更新
     * @param dto 支付宝海豚核销数据统计
     * @return 影响行数
     */
    int update(AlipayCountCoinsWriteOffDataStatisticDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据券模板Ids查询-截止到目前为止
     * @param templateIds 券模板Ids
     * @return 支付宝消耗详情列表
     */
    List<AlipayCountCoinsWriteOffDataStatisticDto> selectByTemplateIdsNow(List<String> templateIds);
}
