package cn.com.duiba.quanyi.center.api.enums.product;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * @author cxw
 * @date 2025/06/16
 */
@Getter
@AllArgsConstructor
public enum ProductPortfolioEnum {

    CUSTOM_ACTIVITY(1, "定制活动"),
    POINTS_MALL_CUSTOM(2, "积分商城定制"),
    POINTS_MALL_VERSION(3, "积分商城版本"),
    POINTS_MALL_OPERATION(4, "积分商城代运营"),
    SYSTEM_DEVELOPMENT(5, "系统开发（本地化）"),
    AD(6, "投流"),
    OPERATION_MANAGEMENT(7, "代运营"),
    ON_SITE_SUPPORT(8, "驻场"),
    LIVE_STREAMING(9, "直播"),
    OFFICIAL_ACCOUNT_OPERATION(10, "公众号代运营"),
    COMMUNITY_OPERATION(11, "社群代运营"),
    VIDEO_PRODUCTION(12, "视频拍摄"),
    SAAS_AND_JI_KE_ASSISTANT(13, "SaaS服务&集客助手"),
    SHORT_VIDEO_PRODUCTION(14, "短剧拍摄"),
    RIGHTS_AND_INTERESTS(15, "权益"),
    OTHER(16, "其他");

    private final Integer code;
    private final String desc;

    /**
     * 根据编码获取描述
     *
     * @param code 编码
     * @return 描述信息
     */
    public static String getDescByCode(Integer code) {
        for (ProductPortfolioEnum item : ProductPortfolioEnum.values()) {
            if (item.getCode().equals(code)) {
                return item.getDesc();
            }
        }
        return null;
    }

    /**
     * 根据编码获取描述
     *
     * @param codes 编码
     * @return 描述信息
     */
    public static String getDescByCodes(String codes) {
        if (StringUtils.isEmpty(codes)) {
            return null;
        }
        return Arrays.stream(codes.split(",")).map(x -> getDescByCode(Integer.parseInt(x))).collect(Collectors.joining(","));
    }
}
