package cn.com.duiba.quanyi.center.api.param.project;

import cn.com.duiba.quanyi.center.api.dto.project.ProjectGoodsDto;
import cn.com.duiba.quanyi.center.api.dto.project.ProjectProductDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 项目保存或更新参数
 * @author lfh
 */
@Data
public class ProjectSaveOrUpdateParam implements Serializable {

    private static final long serialVersionUID = 8851836354294403515L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 关联客户ID
     */
    private Long partnerId;

    /**
     * 商务负责人ID
     */
    private Long commerceManagerId;

    /**
     * 商务负责人姓名
     */
    private String commerceManagerName;

    /**
     * 运营负责人ID
     */
    private Long operationsManagerId;

    /**
     * 运营负责人姓名
     */
    private String operationsManagerName;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 审核状态
     * {@link cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum}
     */
    private Integer approvalStatus;

    /**
     * 项目交付形式
     */
    private String deliveryMethod;

    /**
     * 交付风险评估
     */
    private String deliveryRiskAssessment;

    /**
     * 结算风险评估
     */
    private String settlementRiskAssessment;


    /**
     * 所属业务
     * @see cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum#getType()
     */
    private Integer belongingBusiness;
    /**
     * 项目关联商品信息
     */
    private List<ProjectGoodsDto> goodsList;

    /**
     * 项目关联产品信息
     */
    private List<ProjectProductDto> productList;

    /**
     * 回款超期天数
     */
    private Integer receivedOverdueDays;

}
