package cn.com.duiba.quanyi.center.api.dto.qy.autogrant;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.activity.TakeTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum;
import lombok.Data;

/**
 * 自动塞券任务表
 * @author mybatis generator 
 * @date 2025-01-22
 */
@Data
public class AutoGrantGoodsOrderTaskDto implements Serializable {
     
    private static final long serialVersionUID = 17375163345436252L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 批量领取订单Id
     */
    private Long batchOrderId;

    /**
     * 批量领取订单号
     */
    private String batchOrderNo;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 已发放次数
     */
    private Integer currentGrantCount;

    /**
     * 需要发放的总次数
     */
    private Integer needGrantTotal;

    /**
     * 下次发放的时间
     */
    private Date nextGrantTime;

    /**
     * 商品库订单业务主键
     */
    private Long goodsBizId;

    /**
     * 商品库订单业务类型, 1-白名单活动，2-商品包
     *
     * @see GoodsOrderBizTypeEnum#getType()
     */
    private Integer goodsBizType;

    /**
     * 领取方式：1-单一领取，2-一键领取
     *
     * @see TakeTypeEnum#getType()
     */
    private Integer takeType;

    /**
     * 最新extParam参数
     */
    private String extParam;
}