package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.CouponWarnConfigDto;
import cn.com.duiba.quanyi.center.api.param.coupon.CouponWarnConfigSearchParam;

import java.util.List;

/**
 * 批次告警配置表
 *
 * @author xuzhigang
 * @date 2025-10-30 14:30
 */
@AdvancedFeignClient
public interface RemoteCouponWarnConfigService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 批次告警配置集合
     */
    List<CouponWarnConfigDto> selectPage(CouponWarnConfigSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CouponWarnConfigSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 批次告警配置
     */
    CouponWarnConfigDto selectById(Long id);

    /**
     * 根据批次ID和批次类型查询
     *
     * @param couponId   批次id
     * @param couponType 批次类型
     * @param warnType   告警类型
     * @return 批次告警配置
     */
    CouponWarnConfigDto selectByCouponIdAndType(Long couponId, Integer couponType, Integer warnType);

    /**
     * 新增
     *
     * @param dto 批次告警配置
     * @return 执行结果
     */
    int insert(CouponWarnConfigDto dto);

    /**
     * 更新
     *
     * @param dto 批次告警配置
     * @return 影响行数
     */
    int update(CouponWarnConfigDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据批次ID和批次类型删除
     *
     * @param couponId   批次id
     * @param couponType 批次类型
     * @param warnType   告警类型
     * @return 执行结果
     */
    int deleteByCouponIdAndType(Long couponId, Integer couponType, Integer warnType);
}

