package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.StockConsumeHalfHourStatisticDiDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.StockConsumeHalfHourStatisticDiSearchParam;
import java.util.List;

/**
 * 批次半小时消耗统计数据
 * @author kjj mybatis generator 
 * @date 2025-02-19
 */
@AdvancedFeignClient
public interface RemoteStockConsumeHalfHourStatisticDiService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 批次半小时消耗统计数据集合
     */
    List<StockConsumeHalfHourStatisticDiDto> selectPage(StockConsumeHalfHourStatisticDiSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(StockConsumeHalfHourStatisticDiSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 批次半小时消耗统计数据
     */
    StockConsumeHalfHourStatisticDiDto selectById(Long id);

    /**
     * 新增
     * @param dto 批次半小时消耗统计数据
     * @return 执行结果
     */
    int insert(StockConsumeHalfHourStatisticDiDto dto);

    /**
     * 更新
     * @param dto 批次半小时消耗统计数据
     * @return 影响行数
     */
    int update(StockConsumeHalfHourStatisticDiDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}