package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 微信立减金每日统计数据
 * @author mybatis generator 
 * @date 2024-03-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxCouponStatisticDaySearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17098790725791668L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 批次id
     */
    private String stockId;

    /**
     * 统计日期 yyyy-mm-dd
     */
    private Date curDate;

    /**
     * 已发放总数
     */
    private Long totalDistributedNum;

    /**
     * 当日已发放数量
     */
    private Long curDistributedNum;

    /**
     * 已发放总金额
     */
    private Long totalDistributedAmount;

    /**
     * 已发放总金额
     */
    private Long curDistributedAmount;
}