package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 批次告警配置表查询参数
 *
 * @author xuzhigang
 * @date 2025-10-30 14:30
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CouponWarnConfigSearchParam extends PageQuery {

    private static final long serialVersionUID = 2910419183061184544L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 批次id
     */
    private Long couponId;

    /**
     * 批次类型,1-微信立减金,2-支付宝立减金
     */
    private Integer couponType;

    /**
     * 开启状态,0-关闭,1-开启
     */
    private Integer enableStatus;

    /**
     * 告警类型：1-库存告警，2-时间告警
     */
    private Integer warnType;
}

