package cn.com.duiba.quanyi.center.api.remoteservice.demand;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandAddGoodsResultDto;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandContractRefDto;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandDto;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandInfoDto;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandSaveOrUpdateResultDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandAddGoodsParam;
import cn.com.duiba.quanyi.center.api.param.demand.DemandGoodsCompletePurchaseParam;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPageEsParam;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPageQueryParam;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPurchaseRecordSaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.demand.DemandRefundContractOccupyAmountParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 需求表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteDemandService {
    /**
     * 根据主键查询
     *
     * @param list 主键
     * @return 需求
     */
    Map<Long, DemandDto> selectByIdList(Set<Long> list);

    /**
     * 根据对接人id查询
     * @param contactsId 对接人id
     * @return 需求id集合
     */
    List<Long> selectDemandIdListByContactsId(Long contactsId);

    /**
     * 根据需求id集合查询需求名称
     * @param list 需求id集合
     * @return 需求id: 需求名称
     */
    Map<Long, String> selectDemandNameMap(Set<Long> list);

    /**
     * 分页查询
     *
     * @param param 请求参数
     * @return 需求列表
     */
    List<DemandDto> selectPage(DemandPageQueryParam param);

    /**
     * 分页查询(ES专用）
     *
     * @param param 请求参数
     * @return 需求列表
     */
    Pair<Long, List<DemandDto>> selectEsPage(DemandPageEsParam param);

    /**
     * 查询(不分页)
     *
     * @param demandPageQueryParam 参数
     * @return 结果
     */
    List<DemandDto> selectNoPage(DemandPageQueryParam demandPageQueryParam);

    /**
     * count
     *
     * @param param 请求参数
     * @return 数量
     */
    Integer count(DemandPageQueryParam param);

    /**
     * 新增
     *
     * @param demandDto
     * @return
     */
    Long insert(DemandDto demandDto);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    DemandDto findById(Long id);
    /**
     * 根据id查询需求 本地缓存
     *
     * @param id
     * @return
     */
    DemandDto findByIdWithLocal(Long id);

    /**
     * 更新
     *
     * @param demandDto
     * @return
     */
    int update(DemandDto demandDto);

    /**
     * 根据需求id删除对应的需求记录
     * @param id 需求主键id字段
     */
    void delete(Long id);

    /**
     * 保存需求
     *
     * @param demandInfoDto demand info dto
     * @return {@link Long }
     */
    DemandSaveOrUpdateResultDto saveOrUpdate(DemandInfoDto demandInfoDto) throws BizException;

    /**
     * 添加商品
     * @param param 添加商品参数
     * @return 是否添加成功
     */
    DemandAddGoodsResultDto addGoods(DemandAddGoodsParam param) throws BizException;

    /**
     * 完成采购
     * @param demandId 需求ID
     * @param goodsList 商品类型
     * @return 是否成功
     */
    boolean completePurchase(Long demandId, List<DemandGoodsCompletePurchaseParam> goodsList);


    /**
     * 根据项目id查询需求信息
     *
     * @param projectIds 项目id集合
     * @return 需求信息列表
     */
    List<DemandDto> selectByProjectIds(List<Long> projectIds);

    /**
     * 根据需求名称查询需求信息
     *
     * @param name 需求名称
     * @return 需求信息列表
     */
    List<DemandDto> selectByName(String name);

    /**
     * 需求采购凭证保存或修改
     * @param param 参数
     * @return 返回结果
     */
    Boolean saveOrUpdatePurchase(DemandPurchaseRecordSaveOrUpdateParam param);

    /**
     * 需求合同关联列表-修改
     *
     * @param demandId 需求id
     * @param refList  需求合同关联
     * @param operatorSsoId 操作人id
     * @param operatorSsoName 操作人名称
     * @return true：成功，false：失败
     * @throws BizException 修改失败
     */
    boolean contractRefModify(Long demandId, List<DemandContractRefDto> refList, Long operatorSsoId, String operatorSsoName) throws BizException;

    /**
     * 根据项目id和创建人查询需求id，仅筛选已通过审核的需求
     *
     * @param projectId        项目id 必填
     * @param createOperatorId 创建人id 可选
     */
    List<Long> selectIdByProjectIdAndCreator(Long projectId, Long createOperatorId);

    /**
     * 回退合同占用金额
     *
     * @param param 参数
     * @throws BizException 异常
     */
    boolean refundContractAmount(DemandRefundContractOccupyAmountParam param) throws BizException;
}
