package cn.com.duiba.quanyi.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 批次告警配置表
 *
 * @author xuzhigang
 * @date 2025-10-30 14:30
 */
@Data
public class CouponWarnConfigDto implements Serializable {

    private static final long serialVersionUID = 3456789012345678901L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 批次id
     */
    private Long couponId;

    /**
     * 批次类型,1-微信立减金,2-支付宝立减金
     */
    private Integer couponType;

    /**
     * 开启状态,0-关闭,1-开启
     */
    private Integer enableStatus;

    /**
     * 库存告警配置
     */
    private String stockWarnConfig;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 告警类型：1-库存告警，2-时间告警
     */
    private Integer warnType;
}

