package cn.com.duiba.quanyi.center.api.param.invoice;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * 发票回款超期排行榜查询参数
 * @author xuzhigang
 * @date 2025/1/21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InvoiceReceivedOverdueRankSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17364024890963779L;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 商务负责人ID
     */
    private Long commerceManagerId;

    /**
     * 运营负责人ID
     */
    private Long operationsManagerId;

    /**
     * 查看者ID（用于权限控制）
     */
    private Long viewerId;

    /**
     * 是否管理员（用于权限控制）
     */
    private Boolean isAdmin;
}
