package cn.com.duiba.quanyi.center.api.remoteservice.common;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.common.UploadTaskExtDto;

/**
 * 上传任务拓展表
 * @author kjj mybatis generator 
 * @date 2025-05-13
 */
@AdvancedFeignClient
public interface RemoteUploadTaskExtService {

    /**
     * 筛选有效期时间范围
     * @param bizId 业务id
     * @param bizType 业务类型
     * @return
     */
    List<UploadTaskExtDto> selectEffectiveDate(Long bizId, Integer bizType);

    /**
     * 筛选有效期时间范围
     * @param bizId 业务id
     * @param bizType 业务类型
     * @param isFilterExpired 是否过滤过期数据
     * @return
     */
    List<UploadTaskExtDto> selectEffectiveDateAndIsFilterExpired(Long bizId, Integer bizType, Boolean isFilterExpired);

    /**
     * 新增
     * @param dto 上传任务拓展
     * @return 执行结果
     */
    int save(UploadTaskExtDto dto);

    /*
     * 保存/更新任务扩展信息
     * @param dto 扩展信息
     * @return 成功条数
     */
    int saveOrUpdate(UploadTaskExtDto dto);

    /**
     * 根据任务id查询扩展信息
     * @param taskIdList 任务id列表
     * @return 扩展信息map
     */
    List<UploadTaskExtDto> selectByTaskIds(List<Long> taskIdList);

    /**
     * 根据任务id查询
     * @param taskId 任务id
     * @return 扩展信息
     */
    UploadTaskExtDto selectByTaskId(Long taskId);
}