package cn.com.duiba.quanyi.center.api.remoteservice.taibao.cq;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.taibao.cq.CqtbNotifyRecordDto;
import cn.com.duiba.quanyi.center.api.param.taibao.cq.CqtbNotifyRecordSearchParam;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 重庆太保定制-推送记录
 * @author kjj mybatis generator 
 * @date 2025-02-08
 */
@AdvancedFeignClient
public interface RemoteCqtbNotifyRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 重庆太保定制-推送记录集合
     */
    List<CqtbNotifyRecordDto> selectPage(CqtbNotifyRecordSearchParam param);

    /**
     * 根据单号和时间查询
     * @param notifyType 推送类型
     * @see cn.com.duiba.quanyi.center.api.enums.taibao.cq.CqtbNotifyRecordTypeEnum
     * @param orderNo 推送单号
     * @param endTime 结束时间
     * @return 重庆太保定制-推送记录集合
     */
    List<CqtbNotifyRecordDto> selectByOrder(Integer notifyType, String orderNo, Date endTime);

    /**
     * 更新结果
     * @param id 主键
     * @param fromStatus 原状态
     * @param toStatus 更改后状态
     * @param callResult 推送结果
     * @param notifyOrderStatus 实际推送的订单状态
     * @return 影响行数
     */
    int updateResult(Long id, Integer fromStatus, Integer toStatus, String callResult, Integer notifyOrderStatus);

    /**
     * 批量物理删除
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDelete(Set<Long> ids);
}