package cn.com.duiba.quanyi.center.api.param.demand;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 查询商城需求商品
 * @author cxw
 * @date 2025/08/29
 */
@Data
public class DemandGoodsMallQueryParam implements Serializable {

    private static final long serialVersionUID = 1036399092666994739L;
    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * skuId
     */
    private List<Long> skuIds;

    /**
     * 面额，单位分
     */
    private Long amount;

    /**
     * 面额类型：1-固定，2-不固定
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

}
