package cn.com.duiba.quanyi.center.api.enums.activity.common;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2025/4/28 10:13
 */
@Getter
@AllArgsConstructor
public enum ActivityCommonSubTypeEnum {
    TEMPLATE(1, "模板活动", false, 0),
    BOC_COMMON(2, "中行通用活动", true, 0),
    BOC_ZJ_ZQY(4, "浙江中行-郑茜伊", true, 1),
    BOC_ZJ(5, "浙江中行", true, 1),
    BOC_ZJ_KA_BU(6, "浙江中行-卡部", true, 1),
    BOC_SZ_BL_WX(7, "深圳中行特色活动便利仓-微信", true, 1),
    BOC_HB_APP(8, "湖北中行-手机银行", true, 1),
    BOC_SZ_BL_APP(9, "深圳中行特色活动便利仓-手机银行", true, 1),
    BOC_HB_WX(10, "湖北中行-微信", true, 1),
    BOC_XJ_SCHOOL(11, "新疆中行-高校领奖活动", true, 1),

    TEST_CUSTOM(999999999, "测试定制活动", true, 0),
    ;

    private final Integer type;

    private final String desc;

    /**
     * 是否是定制
     */
    private final boolean custom;

    /**
     * 标签属性- 0 两个通用 1活动使用， 2 集合页使用
     */
    private final Integer tag;

    /**
     * 根据type获取枚举信息
     */
    public static ActivityCommonSubTypeEnum getByType(Integer type) {
        return Arrays.stream(ActivityCommonSubTypeEnum.values())
                .filter(item -> item.getType().equals(type))
                .findFirst()
                .orElse(null);
    }

    /**
     * 查询所有定制活动
     */
    public static List<ActivityCommonSubTypeEnum> getCustomEnums() {
        return Arrays.stream(ActivityCommonSubTypeEnum.values())
                .filter(ActivityCommonSubTypeEnum::isCustom)
                .collect(Collectors.toList());
    }
}
